// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    public partial class DataBoxEncryptionPreferences : IUtf8JsonSerializable, IJsonModel<DataBoxEncryptionPreferences>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataBoxEncryptionPreferences>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataBoxEncryptionPreferences>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEncryptionPreferences>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataBoxEncryptionPreferences)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DoubleEncryption))
            {
                writer.WritePropertyName("doubleEncryption"u8);
                writer.WriteStringValue(DoubleEncryption.Value.ToSerialString());
            }
            if (Optional.IsDefined(HardwareEncryption))
            {
                writer.WritePropertyName("hardwareEncryption"u8);
                writer.WriteStringValue(HardwareEncryption.Value.ToSerialString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DataBoxEncryptionPreferences IJsonModel<DataBoxEncryptionPreferences>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEncryptionPreferences>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataBoxEncryptionPreferences)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataBoxEncryptionPreferences(document.RootElement, options);
        }

        internal static DataBoxEncryptionPreferences DeserializeDataBoxEncryptionPreferences(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DataBoxDoubleEncryption? doubleEncryption = default;
            HardwareEncryption? hardwareEncryption = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("doubleEncryption"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    doubleEncryption = property.Value.GetString().ToDataBoxDoubleEncryption();
                    continue;
                }
                if (property.NameEquals("hardwareEncryption"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hardwareEncryption = property.Value.GetString().ToHardwareEncryption();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataBoxEncryptionPreferences(doubleEncryption, hardwareEncryption, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DataBoxEncryptionPreferences>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEncryptionPreferences>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DataBoxEncryptionPreferences)} does not support writing '{options.Format}' format.");
            }
        }

        DataBoxEncryptionPreferences IPersistableModel<DataBoxEncryptionPreferences>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxEncryptionPreferences>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataBoxEncryptionPreferences(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataBoxEncryptionPreferences)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataBoxEncryptionPreferences>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
