// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    public partial class DataBoxDiskSecret : IUtf8JsonSerializable, IJsonModel<DataBoxDiskSecret>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataBoxDiskSecret>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataBoxDiskSecret>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxDiskSecret>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataBoxDiskSecret)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(DiskSerialNumber))
            {
                writer.WritePropertyName("diskSerialNumber"u8);
                writer.WriteStringValue(DiskSerialNumber);
            }
            if (options.Format != "W" && Optional.IsDefined(BitLockerKey))
            {
                writer.WritePropertyName("bitLockerKey"u8);
                writer.WriteStringValue(BitLockerKey);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DataBoxDiskSecret IJsonModel<DataBoxDiskSecret>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxDiskSecret>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataBoxDiskSecret)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataBoxDiskSecret(document.RootElement, options);
        }

        internal static DataBoxDiskSecret DeserializeDataBoxDiskSecret(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string diskSerialNumber = default;
            string bitLockerKey = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("diskSerialNumber"u8))
                {
                    diskSerialNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("bitLockerKey"u8))
                {
                    bitLockerKey = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataBoxDiskSecret(diskSerialNumber, bitLockerKey, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DataBoxDiskSecret>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxDiskSecret>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DataBoxDiskSecret)} does not support writing '{options.Format}' format.");
            }
        }

        DataBoxDiskSecret IPersistableModel<DataBoxDiskSecret>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataBoxDiskSecret>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataBoxDiskSecret(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataBoxDiskSecret)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataBoxDiskSecret>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
