// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> DataBox Disk Copy Progress. </summary>
    public partial class DataBoxDiskCopyProgress
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxDiskCopyProgress"/>. </summary>
        internal DataBoxDiskCopyProgress()
        {
            Actions = new ChangeTrackingList<CustomerResolutionCode>();
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxDiskCopyProgress"/>. </summary>
        /// <param name="serialNumber"> The serial number of the disk. </param>
        /// <param name="bytesCopied"> Bytes copied during the copy of disk. </param>
        /// <param name="percentComplete"> Indicates the percentage completed for the copy of the disk. </param>
        /// <param name="status"> The Status of the copy. </param>
        /// <param name="error"> Error, if any, in the stage. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxDiskCopyProgress(string serialNumber, long? bytesCopied, int? percentComplete, DataBoxCopyStatus? status, ResponseError error, IReadOnlyList<CustomerResolutionCode> actions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SerialNumber = serialNumber;
            BytesCopied = bytesCopied;
            PercentComplete = percentComplete;
            Status = status;
            Error = error;
            Actions = actions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The serial number of the disk. </summary>
        public string SerialNumber { get; }
        /// <summary> Bytes copied during the copy of disk. </summary>
        public long? BytesCopied { get; }
        /// <summary> Indicates the percentage completed for the copy of the disk. </summary>
        public int? PercentComplete { get; }
        /// <summary> The Status of the copy. </summary>
        public DataBoxCopyStatus? Status { get; }
        /// <summary> Error, if any, in the stage. </summary>
        public ResponseError Error { get; }
        /// <summary> Available actions on the job. </summary>
        public IReadOnlyList<CustomerResolutionCode> Actions { get; }
    }
}
