// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Credential details of the account. </summary>
    public partial class DataBoxAccountCredentialDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataBoxAccountCredentialDetails"/>. </summary>
        internal DataBoxAccountCredentialDetails()
        {
            ShareCredentialDetails = new ChangeTrackingList<ShareCredentialDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="DataBoxAccountCredentialDetails"/>. </summary>
        /// <param name="accountName"> Name of the account. </param>
        /// <param name="dataAccountType"> Type of the account. </param>
        /// <param name="accountConnectionString"> Connection string of the account endpoint to use the account as a storage endpoint on the device. </param>
        /// <param name="shareCredentialDetails"> Per share level unencrypted access credentials. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataBoxAccountCredentialDetails(string accountName, DataAccountType? dataAccountType, string accountConnectionString, IReadOnlyList<ShareCredentialDetails> shareCredentialDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AccountName = accountName;
            DataAccountType = dataAccountType;
            AccountConnectionString = accountConnectionString;
            ShareCredentialDetails = shareCredentialDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the account. </summary>
        public string AccountName { get; }
        /// <summary> Type of the account. </summary>
        public DataAccountType? DataAccountType { get; }
        /// <summary> Connection string of the account endpoint to use the account as a storage endpoint on the device. </summary>
        public string AccountConnectionString { get; }
        /// <summary> Per share level unencrypted access credentials. </summary>
        public IReadOnlyList<ShareCredentialDetails> ShareCredentialDetails { get; }
    }
}
