// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class DataAccountTypeExtensions
    {
        public static string ToSerialString(this DataAccountType value) => value switch
        {
            DataAccountType.StorageAccount => "StorageAccount",
            DataAccountType.ManagedDisk => "ManagedDisk",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataAccountType value.")
        };

        public static DataAccountType ToDataAccountType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "StorageAccount")) return DataAccountType.StorageAccount;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ManagedDisk")) return DataAccountType.ManagedDisk;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataAccountType value.");
        }
    }
}
