// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class CustomerResolutionCodeExtensions
    {
        public static string ToSerialString(this CustomerResolutionCode value) => value switch
        {
            CustomerResolutionCode.None => "None",
            CustomerResolutionCode.MoveToCleanUpDevice => "MoveToCleanUpDevice",
            CustomerResolutionCode.Resume => "Resume",
            CustomerResolutionCode.Restart => "Restart",
            CustomerResolutionCode.ReachOutToOperation => "ReachOutToOperation",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CustomerResolutionCode value.")
        };

        public static CustomerResolutionCode ToCustomerResolutionCode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return CustomerResolutionCode.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "MoveToCleanUpDevice")) return CustomerResolutionCode.MoveToCleanUpDevice;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Resume")) return CustomerResolutionCode.Resume;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Restart")) return CustomerResolutionCode.Restart;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ReachOutToOperation")) return CustomerResolutionCode.ReachOutToOperation;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CustomerResolutionCode value.");
        }
    }
}
