// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Properties of create order limit for subscription validation response. </summary>
    public partial class CreateOrderLimitForSubscriptionValidationResult : DataBoxValidationInputResult
    {
        /// <summary> Initializes a new instance of <see cref="CreateOrderLimitForSubscriptionValidationResult"/>. </summary>
        internal CreateOrderLimitForSubscriptionValidationResult()
        {
            ValidationType = DataBoxValidationInputDiscriminator.ValidateCreateOrderLimit;
        }

        /// <summary> Initializes a new instance of <see cref="CreateOrderLimitForSubscriptionValidationResult"/>. </summary>
        /// <param name="validationType"> Identifies the type of validation response. </param>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="status"> Create order limit validation status. </param>
        internal CreateOrderLimitForSubscriptionValidationResult(DataBoxValidationInputDiscriminator validationType, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData, DataBoxValidationStatus? status) : base(validationType, error, serializedAdditionalRawData)
        {
            Status = status;
            ValidationType = validationType;
        }

        /// <summary> Create order limit validation status. </summary>
        public DataBoxValidationStatus? Status { get; }
    }
}
