// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBox.Models
{
    public partial class CreateJobValidationContent : IUtf8JsonSerializable, IJsonModel<CreateJobValidationContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CreateJobValidationContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CreateJobValidationContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CreateJobValidationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CreateJobValidationContent)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
        }

        CreateJobValidationContent IJsonModel<CreateJobValidationContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CreateJobValidationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CreateJobValidationContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCreateJobValidationContent(document.RootElement, options);
        }

        internal static CreateJobValidationContent DeserializeCreateJobValidationContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DataBoxValidationCategory validationCategory = default;
            IList<DataBoxValidationInputContent> individualRequestDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("validationCategory"u8))
                {
                    validationCategory = new DataBoxValidationCategory(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("individualRequestDetails"u8))
                {
                    List<DataBoxValidationInputContent> array = new List<DataBoxValidationInputContent>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DataBoxValidationInputContent.DeserializeDataBoxValidationInputContent(item, options));
                    }
                    individualRequestDetails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CreateJobValidationContent(validationCategory, individualRequestDetails, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CreateJobValidationContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CreateJobValidationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CreateJobValidationContent)} does not support writing '{options.Format}' format.");
            }
        }

        CreateJobValidationContent IPersistableModel<CreateJobValidationContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CreateJobValidationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCreateJobValidationContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CreateJobValidationContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CreateJobValidationContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
