// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Filter details to transfer Azure Blobs. </summary>
    public partial class BlobFilterDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BlobFilterDetails"/>. </summary>
        public BlobFilterDetails()
        {
            BlobPrefixList = new ChangeTrackingList<string>();
            BlobPathList = new ChangeTrackingList<string>();
            ContainerList = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="BlobFilterDetails"/>. </summary>
        /// <param name="blobPrefixList"> Prefix list of the Azure blobs to be transferred. </param>
        /// <param name="blobPathList"> List of full path of the blobs to be transferred. </param>
        /// <param name="containerList"> List of blob containers to be transferred. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BlobFilterDetails(IList<string> blobPrefixList, IList<string> blobPathList, IList<string> containerList, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BlobPrefixList = blobPrefixList;
            BlobPathList = blobPathList;
            ContainerList = containerList;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Prefix list of the Azure blobs to be transferred. </summary>
        public IList<string> BlobPrefixList { get; }
        /// <summary> List of full path of the blobs to be transferred. </summary>
        public IList<string> BlobPathList { get; }
        /// <summary> List of blob containers to be transferred. </summary>
        public IList<string> ContainerList { get; }
    }
}
