// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataBox.Models
{
    internal static partial class AddressValidationStatusExtensions
    {
        public static string ToSerialString(this AddressValidationStatus value) => value switch
        {
            AddressValidationStatus.Valid => "Valid",
            AddressValidationStatus.Invalid => "Invalid",
            AddressValidationStatus.Ambiguous => "Ambiguous",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AddressValidationStatus value.")
        };

        public static AddressValidationStatus ToAddressValidationStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Valid")) return AddressValidationStatus.Valid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Invalid")) return AddressValidationStatus.Invalid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Ambiguous")) return AddressValidationStatus.Ambiguous;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AddressValidationStatus value.");
        }
    }
}
