// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> The address validation output. </summary>
    public partial class AddressValidationResult : DataBoxValidationInputResult
    {
        /// <summary> Initializes a new instance of <see cref="AddressValidationResult"/>. </summary>
        internal AddressValidationResult()
        {
            AlternateAddresses = new ChangeTrackingList<DataBoxShippingAddress>();
            ValidationType = DataBoxValidationInputDiscriminator.ValidateAddress;
        }

        /// <summary> Initializes a new instance of <see cref="AddressValidationResult"/>. </summary>
        /// <param name="validationType"> Identifies the type of validation response. </param>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="validationStatus"> The address validation status. </param>
        /// <param name="alternateAddresses"> List of alternate addresses. </param>
        internal AddressValidationResult(DataBoxValidationInputDiscriminator validationType, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData, AddressValidationStatus? validationStatus, IReadOnlyList<DataBoxShippingAddress> alternateAddresses) : base(validationType, error, serializedAdditionalRawData)
        {
            ValidationStatus = validationStatus;
            AlternateAddresses = alternateAddresses;
            ValidationType = validationType;
        }

        /// <summary> The address validation status. </summary>
        public AddressValidationStatus? ValidationStatus { get; }
        /// <summary> List of alternate addresses. </summary>
        public IReadOnlyList<DataBoxShippingAddress> AlternateAddresses { get; }
    }
}
