// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Output of the address validation api. </summary>
    public partial class AddressValidationOutput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AddressValidationOutput"/>. </summary>
        internal AddressValidationOutput()
        {
            AlternateAddresses = new ChangeTrackingList<DataBoxShippingAddress>();
        }

        /// <summary> Initializes a new instance of <see cref="AddressValidationOutput"/>. </summary>
        /// <param name="validationType"> Identifies the type of validation response. </param>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="validationStatus"> The address validation status. </param>
        /// <param name="alternateAddresses"> List of alternate addresses. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AddressValidationOutput(DataBoxValidationInputDiscriminator? validationType, ResponseError error, AddressValidationStatus? validationStatus, IReadOnlyList<DataBoxShippingAddress> alternateAddresses, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ValidationType = validationType;
            Error = error;
            ValidationStatus = validationStatus;
            AlternateAddresses = alternateAddresses;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Identifies the type of validation response. </summary>
        internal DataBoxValidationInputDiscriminator? ValidationType { get; set; }
        /// <summary> Error code and message of validation response. </summary>
        public ResponseError Error { get; }
        /// <summary> The address validation status. </summary>
        public AddressValidationStatus? ValidationStatus { get; }
        /// <summary> List of alternate addresses. </summary>
        public IReadOnlyList<DataBoxShippingAddress> AlternateAddresses { get; }
    }
}
