// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataBox.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmDataBoxModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="DataBox.DataBoxJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="transferType"> Type of the data transfer. </param>
        /// <param name="isCancellable"> Describes whether the job is cancellable or not. </param>
        /// <param name="isDeletable"> Describes whether the job is deletable or not. </param>
        /// <param name="isShippingAddressEditable"> Describes whether the shipping address is editable or not. </param>
        /// <param name="reverseShippingDetailsUpdate"> The Editable status for Reverse Shipping Address and Contact Info. </param>
        /// <param name="reverseTransportPreferenceUpdate"> The Editable status for Reverse Transport preferences. </param>
        /// <param name="isPrepareToShipEnabled"> Is Prepare To Ship Enabled on this job. </param>
        /// <param name="status"> Name of the stage which is in progress. </param>
        /// <param name="startOn"> Time at which the job was started in UTC ISO 8601 format. </param>
        /// <param name="error"> Top level error for the job. </param>
        /// <param name="details">
        /// Details of a job run. This field will only be sent for expand details filter.
        /// Please note <see cref="Models.DataBoxBasicJobDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataBoxJobDetails"/>, <see cref="Models.DataBoxCustomerDiskJobDetails"/>, <see cref="Models.DataBoxDiskJobDetails"/> and <see cref="Models.DataBoxHeavyJobDetails"/>.
        /// </param>
        /// <param name="cancellationReason"> Reason for cancellation. </param>
        /// <param name="deliveryType"> Delivery type of Job. </param>
        /// <param name="deliveryInfoScheduledOn"> Delivery Info of Job. </param>
        /// <param name="isCancellableWithoutFee"> Flag to indicate cancellation of scheduled job. </param>
        /// <param name="sku"> The sku type. </param>
        /// <param name="identity"> Msi identity of the resource. </param>
        /// <returns> A new <see cref="DataBox.DataBoxJobData"/> instance for mocking. </returns>
        public static DataBoxJobData DataBoxJobData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DataBoxJobTransferType transferType = default, bool? isCancellable = null, bool? isDeletable = null, bool? isShippingAddressEditable = null, ReverseShippingDetailsEditStatus? reverseShippingDetailsUpdate = null, ReverseTransportPreferenceEditStatus? reverseTransportPreferenceUpdate = null, bool? isPrepareToShipEnabled = null, DataBoxStageName? status = null, DateTimeOffset? startOn = null, ResponseError error = null, DataBoxBasicJobDetails details = null, string cancellationReason = null, JobDeliveryType? deliveryType = null, DateTimeOffset? deliveryInfoScheduledOn = null, bool? isCancellableWithoutFee = null, DataBoxSku sku = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DataBoxJobData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                transferType,
                isCancellable,
                isDeletable,
                isShippingAddressEditable,
                reverseShippingDetailsUpdate,
                reverseTransportPreferenceUpdate,
                isPrepareToShipEnabled,
                status,
                startOn,
                error,
                details,
                cancellationReason,
                deliveryType,
                deliveryInfoScheduledOn != null ? new JobDeliveryInfo(deliveryInfoScheduledOn, serializedAdditionalRawData: null) : null,
                isCancellableWithoutFee,
                sku,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxBasicJobDetails"/>. </summary>
        /// <param name="jobStages"> List of stages that run in the job. </param>
        /// <param name="contactDetails"> Contact details for notification and shipping. </param>
        /// <param name="shippingAddress"> Shipping address of the customer. </param>
        /// <param name="deliveryPackage"> Delivery package shipping details. </param>
        /// <param name="returnPackage"> Return package shipping details. </param>
        /// <param name="dataImportDetails"> Details of the data to be imported into azure. </param>
        /// <param name="dataExportDetails"> Details of the data to be exported from azure. </param>
        /// <param name="preferences"> Preferences for the order. </param>
        /// <param name="reverseShippingDetails"> Optional Reverse Shipping details for order. </param>
        /// <param name="copyLogDetails">
        /// List of copy log details.
        /// Please note <see cref="CopyLogDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataBoxAccountCopyLogDetails"/>, <see cref="Models.DataBoxCustomerDiskCopyLogDetails"/>, <see cref="Models.DataBoxDiskCopyLogDetails"/> and <see cref="Models.DataBoxHeavyAccountCopyLogDetails"/>.
        /// </param>
        /// <param name="reverseShipmentLabelSasKey"> Shared access key to download the return shipment label. </param>
        /// <param name="chainOfCustodySasKey"> Shared access key to download the chain of custody logs. </param>
        /// <param name="deviceErasureDetails"> Holds device data erasure details. </param>
        /// <param name="keyEncryptionKey"> Details about which key encryption type is being used. </param>
        /// <param name="expectedDataSizeInTerabytes"> The expected size of the data, which needs to be transferred in this job, in terabytes. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <param name="lastMitigationActionOnJob"> Last mitigation action performed on the job. </param>
        /// <param name="dataCenterAddress">
        /// Datacenter address to ship to, for the given sku and storage location.
        /// Please note <see cref="Models.DataCenterAddressResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataCenterAddressInstructionResult"/> and <see cref="Models.DataCenterAddressLocationResult"/>.
        /// </param>
        /// <param name="dataCenterCode"> DataCenter code. </param>
        /// <returns> A new <see cref="Models.DataBoxBasicJobDetails"/> instance for mocking. </returns>
        public static DataBoxBasicJobDetails DataBoxBasicJobDetails(IEnumerable<DataBoxJobStage> jobStages = null, DataBoxContactDetails contactDetails = null, DataBoxShippingAddress shippingAddress = null, PackageShippingDetails deliveryPackage = null, PackageShippingDetails returnPackage = null, IEnumerable<DataImportDetails> dataImportDetails = null, IEnumerable<DataExportDetails> dataExportDetails = null, DataBoxOrderPreferences preferences = null, ReverseShippingDetails reverseShippingDetails = null, IEnumerable<CopyLogDetails> copyLogDetails = null, string reverseShipmentLabelSasKey = null, string chainOfCustodySasKey = null, DeviceErasureDetails deviceErasureDetails = null, DataBoxKeyEncryptionKey keyEncryptionKey = null, int? expectedDataSizeInTerabytes = null, IEnumerable<CustomerResolutionCode> actions = null, LastMitigationActionOnJob lastMitigationActionOnJob = null, DataCenterAddressResult dataCenterAddress = null, DataCenterCode? dataCenterCode = null)
        {
            jobStages ??= new List<DataBoxJobStage>();
            dataImportDetails ??= new List<DataImportDetails>();
            dataExportDetails ??= new List<DataExportDetails>();
            copyLogDetails ??= new List<CopyLogDetails>();
            actions ??= new List<CustomerResolutionCode>();

            return new UnknownJobDetails(
                jobStages?.ToList(),
                contactDetails,
                shippingAddress,
                deliveryPackage,
                returnPackage,
                dataImportDetails?.ToList(),
                dataExportDetails?.ToList(),
                default,
                preferences,
                reverseShippingDetails,
                copyLogDetails?.ToList(),
                reverseShipmentLabelSasKey,
                chainOfCustodySasKey,
                deviceErasureDetails,
                keyEncryptionKey,
                expectedDataSizeInTerabytes,
                actions?.ToList(),
                lastMitigationActionOnJob,
                dataCenterAddress,
                dataCenterCode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxJobStage"/>. </summary>
        /// <param name="stageName"> Name of the job stage. </param>
        /// <param name="displayName"> Display name of the job stage. </param>
        /// <param name="stageStatus"> Status of the job stage. </param>
        /// <param name="stageTime"> Time for the job stage in UTC ISO 8601 format. </param>
        /// <param name="jobStageDetails"> Job Stage Details. </param>
        /// <returns> A new <see cref="Models.DataBoxJobStage"/> instance for mocking. </returns>
        public static DataBoxJobStage DataBoxJobStage(DataBoxStageName? stageName = null, string displayName = null, DataBoxStageStatus? stageStatus = null, DateTimeOffset? stageTime = null, BinaryData jobStageDetails = null)
        {
            return new DataBoxJobStage(
                stageName,
                displayName,
                stageStatus,
                stageTime,
                jobStageDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PackageShippingDetails"/>. </summary>
        /// <param name="trackingUri"> Url where shipment can be tracked. </param>
        /// <param name="carrierName"> Name of the carrier. </param>
        /// <param name="trackingId"> Tracking Id of shipment. </param>
        /// <returns> A new <see cref="Models.PackageShippingDetails"/> instance for mocking. </returns>
        public static PackageShippingDetails PackageShippingDetails(Uri trackingUri = null, string carrierName = null, string trackingId = null)
        {
            return new PackageShippingDetails(trackingUri, carrierName, trackingId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TransportPreferences"/>. </summary>
        /// <param name="preferredShipmentType"> Indicates Shipment Logistics type that the customer preferred. </param>
        /// <param name="isUpdated"> Read only property which indicates whether transport preferences has been updated or not after device is prepared. </param>
        /// <returns> A new <see cref="Models.TransportPreferences"/> instance for mocking. </returns>
        public static TransportPreferences TransportPreferences(TransportShipmentType preferredShipmentType = default, bool? isUpdated = null)
        {
            return new TransportPreferences(preferredShipmentType, isUpdated, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReverseShippingDetails"/>. </summary>
        /// <param name="contactDetails"> Contact Info. </param>
        /// <param name="shippingAddress"> Shipping address where customer wishes to receive the device. </param>
        /// <param name="isUpdated">
        /// A flag to indicate whether Reverse Shipping details are updated or not after device has been prepared.
        /// Read only field
        /// </param>
        /// <returns> A new <see cref="Models.ReverseShippingDetails"/> instance for mocking. </returns>
        public static ReverseShippingDetails ReverseShippingDetails(ContactInfo contactDetails = null, DataBoxShippingAddress shippingAddress = null, bool? isUpdated = null)
        {
            return new ReverseShippingDetails(contactDetails, shippingAddress, isUpdated, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DeviceErasureDetails"/>. </summary>
        /// <param name="deviceErasureStatus"> Holds the device erasure completion status. </param>
        /// <param name="erasureOrDestructionCertificateSasKey"> Shared access key to download cleanup or destruction certificate for device. </param>
        /// <returns> A new <see cref="Models.DeviceErasureDetails"/> instance for mocking. </returns>
        public static DeviceErasureDetails DeviceErasureDetails(DataBoxStageStatus? deviceErasureStatus = null, string erasureOrDestructionCertificateSasKey = null)
        {
            return new DeviceErasureDetails(deviceErasureStatus, erasureOrDestructionCertificateSasKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LastMitigationActionOnJob"/>. </summary>
        /// <param name="actionPerformedOn"> Action performed date time. </param>
        /// <param name="isPerformedByCustomer">
        /// Action performed by customer,
        /// possibility is that mitigation might happen by customer or service or by ops
        /// </param>
        /// <param name="customerResolution"> Resolution code provided by customer. </param>
        /// <returns> A new <see cref="Models.LastMitigationActionOnJob"/> instance for mocking. </returns>
        public static LastMitigationActionOnJob LastMitigationActionOnJob(DateTimeOffset? actionPerformedOn = null, bool? isPerformedByCustomer = null, CustomerResolutionCode? customerResolution = null)
        {
            return new LastMitigationActionOnJob(actionPerformedOn, isPerformedByCustomer, customerResolution, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCenterAddressResult"/>. </summary>
        /// <param name="supportedCarriersForReturnShipment"> List of supported carriers for return shipment. </param>
        /// <param name="dataCenterAzureLocation"> Azure Location where the Data Center serves primarily. </param>
        /// <returns> A new <see cref="Models.DataCenterAddressResult"/> instance for mocking. </returns>
        public static DataCenterAddressResult DataCenterAddressResult(IEnumerable<string> supportedCarriersForReturnShipment = null, AzureLocation? dataCenterAzureLocation = null)
        {
            supportedCarriersForReturnShipment ??= new List<string>();

            return new UnknownDataCenterAddressResponse(default, supportedCarriersForReturnShipment?.ToList(), dataCenterAzureLocation, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MitigateJobContent"/>. </summary>
        /// <param name="customerResolutionCode"> Resolution code for the job. </param>
        /// <param name="serialNumberCustomerResolutionMap"> Serial number and the customer resolution code corresponding to each serial number. </param>
        /// <returns> A new <see cref="Models.MitigateJobContent"/> instance for mocking. </returns>
        public static MitigateJobContent MitigateJobContent(CustomerResolutionCode customerResolutionCode = default, IDictionary<string, CustomerResolutionCode> serialNumberCustomerResolutionMap = null)
        {
            serialNumberCustomerResolutionMap ??= new Dictionary<string, CustomerResolutionCode>();

            return new MitigateJobContent(customerResolutionCode, serialNumberCustomerResolutionMap, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableSkusContent"/>. </summary>
        /// <param name="transferType"> Type of the transfer. </param>
        /// <param name="country"> ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. </param>
        /// <param name="location"> Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01. </param>
        /// <param name="skuNames"> Sku Names to filter for available skus. </param>
        /// <returns> A new <see cref="Models.AvailableSkusContent"/> instance for mocking. </returns>
        public static AvailableSkusContent AvailableSkusContent(DataBoxJobTransferType transferType = default, string country = null, AzureLocation location = default, IEnumerable<DataBoxSkuName> skuNames = null)
        {
            skuNames ??= new List<DataBoxSkuName>();

            return new AvailableSkusContent(transferType, country, location, skuNames?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxSkuInformation"/>. </summary>
        /// <param name="sku"> The Sku. </param>
        /// <param name="isEnabled"> The sku is enabled or not. </param>
        /// <param name="dataLocationToServiceLocationMap"> The map of data location to service location. </param>
        /// <param name="capacity"> Capacity of the Sku. </param>
        /// <param name="costs"> Cost of the Sku. </param>
        /// <param name="apiVersions"> Api versions that support this Sku. </param>
        /// <param name="disabledReason"> Reason why the Sku is disabled. </param>
        /// <param name="disabledReasonMessage"> Message for why the Sku is disabled. </param>
        /// <param name="requiredFeature"> Required feature to access the sku. </param>
        /// <param name="countriesWithinCommerceBoundary"> List of all the Countries in the SKU specific commerce boundary. </param>
        /// <returns> A new <see cref="Models.DataBoxSkuInformation"/> instance for mocking. </returns>
        public static DataBoxSkuInformation DataBoxSkuInformation(DataBoxSku sku = null, bool? isEnabled = null, IEnumerable<DataLocationToServiceLocationMap> dataLocationToServiceLocationMap = null, DataBoxSkuCapacity capacity = null, IEnumerable<DataBoxSkuCost> costs = null, IEnumerable<string> apiVersions = null, SkuDisabledReason? disabledReason = null, string disabledReasonMessage = null, string requiredFeature = null, IEnumerable<string> countriesWithinCommerceBoundary = null)
        {
            dataLocationToServiceLocationMap ??= new List<DataLocationToServiceLocationMap>();
            costs ??= new List<DataBoxSkuCost>();
            apiVersions ??= new List<string>();
            countriesWithinCommerceBoundary ??= new List<string>();

            return new DataBoxSkuInformation(
                sku,
                isEnabled,
                dataLocationToServiceLocationMap?.ToList(),
                capacity,
                costs?.ToList(),
                apiVersions?.ToList(),
                disabledReason,
                disabledReasonMessage,
                requiredFeature,
                countriesWithinCommerceBoundary?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataLocationToServiceLocationMap"/>. </summary>
        /// <param name="dataLocation"> Location of the data. </param>
        /// <param name="serviceLocation"> Location of the service. </param>
        /// <returns> A new <see cref="Models.DataLocationToServiceLocationMap"/> instance for mocking. </returns>
        public static DataLocationToServiceLocationMap DataLocationToServiceLocationMap(AzureLocation? dataLocation = null, AzureLocation? serviceLocation = null)
        {
            return new DataLocationToServiceLocationMap(dataLocation, serviceLocation, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxSkuCapacity"/>. </summary>
        /// <param name="usable"> Usable capacity in TB. </param>
        /// <param name="maximum"> Maximum capacity in TB. </param>
        /// <returns> A new <see cref="Models.DataBoxSkuCapacity"/> instance for mocking. </returns>
        public static DataBoxSkuCapacity DataBoxSkuCapacity(string usable = null, string maximum = null)
        {
            return new DataBoxSkuCapacity(usable, maximum, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxSkuCost"/>. </summary>
        /// <param name="meterId"> Meter id of the Sku. </param>
        /// <param name="meterType"> The type of the meter. </param>
        /// <param name="multiplier"> Multiplier specifies the region specific value to be multiplied with 1$ guid. Eg: Our new regions will be using 1$ shipping guid with appropriate multiplier specific to region. </param>
        /// <returns> A new <see cref="Models.DataBoxSkuCost"/> instance for mocking. </returns>
        public static DataBoxSkuCost DataBoxSkuCost(Guid? meterId = null, string meterType = null, double? multiplier = null)
        {
            return new DataBoxSkuCost(meterId, meterType, multiplier, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxValidateAddressContent"/>. </summary>
        /// <param name="shippingAddress"> Shipping address of the customer. </param>
        /// <param name="deviceType"> Device type to be used for the job. </param>
        /// <param name="transportPreferences"> Preferences related to the shipment logistics of the sku. </param>
        /// <returns> A new <see cref="Models.DataBoxValidateAddressContent"/> instance for mocking. </returns>
        public static DataBoxValidateAddressContent DataBoxValidateAddressContent(DataBoxShippingAddress shippingAddress = null, DataBoxSkuName deviceType = default, TransportPreferences transportPreferences = null)
        {
            return new DataBoxValidateAddressContent(DataBoxValidationInputDiscriminator.ValidateAddress, serializedAdditionalRawData: null, shippingAddress, deviceType, transportPreferences);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AddressValidationResult"/>. </summary>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="validationStatus"> The address validation status. </param>
        /// <param name="alternateAddresses"> List of alternate addresses. </param>
        /// <returns> A new <see cref="Models.AddressValidationResult"/> instance for mocking. </returns>
        public static AddressValidationResult AddressValidationResult(ResponseError error = null, AddressValidationStatus? validationStatus = null, IEnumerable<DataBoxShippingAddress> alternateAddresses = null)
        {
            alternateAddresses ??= new List<DataBoxShippingAddress>();

            return new AddressValidationResult(DataBoxValidationInputDiscriminator.ValidateAddress, error, serializedAdditionalRawData: null, validationStatus, alternateAddresses?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxValidationInputResult"/>. </summary>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <returns> A new <see cref="Models.DataBoxValidationInputResult"/> instance for mocking. </returns>
        public static DataBoxValidationInputResult DataBoxValidationInputResult(ResponseError error = null)
        {
            return new UnknownValidationInputResponse(default, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxValidationResult"/>. </summary>
        /// <param name="status"> Overall validation status. </param>
        /// <param name="individualResponseDetails">
        /// List of response details contain validationType and its response as key and value respectively.
        /// Please note <see cref="Models.DataBoxValidationInputResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AddressValidationResult"/>, <see cref="Models.CreateOrderLimitForSubscriptionValidationResult"/>, <see cref="Models.DataTransferDetailsValidationResult"/>, <see cref="Models.PreferencesValidationResult"/>, <see cref="Models.SkuAvailabilityValidationResult"/> and <see cref="Models.SubscriptionIsAllowedToCreateJobValidationResult"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataBoxValidationResult"/> instance for mocking. </returns>
        public static DataBoxValidationResult DataBoxValidationResult(OverallValidationStatus? status = null, IEnumerable<DataBoxValidationInputResult> individualResponseDetails = null)
        {
            individualResponseDetails ??= new List<DataBoxValidationInputResult>();

            return new DataBoxValidationResult(status, individualResponseDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxShipmentPickUpResult"/>. </summary>
        /// <param name="confirmationNumber"> Confirmation number for the pick up request. </param>
        /// <param name="readyBy"> Time by which shipment should be ready for pick up, this is in local time of pick up area. </param>
        /// <returns> A new <see cref="Models.DataBoxShipmentPickUpResult"/> instance for mocking. </returns>
        public static DataBoxShipmentPickUpResult DataBoxShipmentPickUpResult(string confirmationNumber = null, DateTimeOffset? readyBy = null)
        {
            return new DataBoxShipmentPickUpResult(confirmationNumber, readyBy, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.UnencryptedCredentials"/>. </summary>
        /// <param name="jobName"> Name of the job. </param>
        /// <param name="jobSecrets">
        /// Secrets related to this job.
        /// Please note <see cref="Models.JobSecrets"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataboxJobSecrets"/>, <see cref="Models.CustomerDiskJobSecrets"/>, <see cref="Models.DataBoxDiskJobSecrets"/> and <see cref="Models.DataBoxHeavyJobSecrets"/>.
        /// </param>
        /// <returns> A new <see cref="Models.UnencryptedCredentials"/> instance for mocking. </returns>
        public static UnencryptedCredentials UnencryptedCredentials(string jobName = null, JobSecrets jobSecrets = null)
        {
            return new UnencryptedCredentials(jobName, jobSecrets, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.JobSecrets"/>. </summary>
        /// <param name="dataCenterAccessSecurityCode"> Dc Access Security Code for Customer Managed Shipping. </param>
        /// <param name="error"> Error while fetching the secrets. </param>
        /// <returns> A new <see cref="Models.JobSecrets"/> instance for mocking. </returns>
        public static JobSecrets JobSecrets(DataCenterAccessSecurityCode dataCenterAccessSecurityCode = null, ResponseError error = null)
        {
            return new UnknownJobSecrets(default, dataCenterAccessSecurityCode, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCenterAccessSecurityCode"/>. </summary>
        /// <param name="reverseDataCenterAccessCode"> Reverse Dc access security code. </param>
        /// <param name="forwardDataCenterAccessCode"> Forward Dc access security code. </param>
        /// <returns> A new <see cref="Models.DataCenterAccessSecurityCode"/> instance for mocking. </returns>
        public static DataCenterAccessSecurityCode DataCenterAccessSecurityCode(string reverseDataCenterAccessCode = null, string forwardDataCenterAccessCode = null)
        {
            return new DataCenterAccessSecurityCode(reverseDataCenterAccessCode, forwardDataCenterAccessCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ScheduleAvailabilityContent"/>. </summary>
        /// <param name="storageLocation"> Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01. </param>
        /// <param name="country"> Country in which storage location should be supported. </param>
        /// <returns> A new <see cref="Models.ScheduleAvailabilityContent"/> instance for mocking. </returns>
        public static ScheduleAvailabilityContent ScheduleAvailabilityContent(AzureLocation storageLocation = default, string country = null)
        {
            return new UnknownScheduleAvailabilityRequest(storageLocation, default, country, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RegionConfigurationResult"/>. </summary>
        /// <param name="scheduleAvailabilityResponseAvailableDates"> Schedule availability for given sku in a region. </param>
        /// <param name="transportAvailabilityDetails"> Transport options available for given sku in a region. </param>
        /// <param name="dataCenterAddressResponse">
        /// Datacenter address for given sku in a region.
        /// Please note <see cref="Models.DataCenterAddressResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataCenterAddressInstructionResult"/> and <see cref="Models.DataCenterAddressLocationResult"/>.
        /// </param>
        /// <returns> A new <see cref="Models.RegionConfigurationResult"/> instance for mocking. </returns>
        public static RegionConfigurationResult RegionConfigurationResult(IEnumerable<DateTimeOffset> scheduleAvailabilityResponseAvailableDates = null, IEnumerable<TransportAvailabilityDetails> transportAvailabilityDetails = null, DataCenterAddressResult dataCenterAddressResponse = null)
        {
            scheduleAvailabilityResponseAvailableDates ??= new List<DateTimeOffset>();
            transportAvailabilityDetails ??= new List<TransportAvailabilityDetails>();

            return new RegionConfigurationResult(scheduleAvailabilityResponseAvailableDates != null ? new ScheduleAvailabilityResponse(scheduleAvailabilityResponseAvailableDates?.ToList(), serializedAdditionalRawData: null) : null, transportAvailabilityDetails != null ? new TransportAvailabilityResponse(transportAvailabilityDetails?.ToList(), serializedAdditionalRawData: null) : null, dataCenterAddressResponse, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TransportAvailabilityDetails"/>. </summary>
        /// <param name="shipmentType"> Transport Shipment Type supported for given region. </param>
        /// <returns> A new <see cref="Models.TransportAvailabilityDetails"/> instance for mocking. </returns>
        public static TransportAvailabilityDetails TransportAvailabilityDetails(TransportShipmentType? shipmentType = null)
        {
            return new TransportAvailabilityDetails(shipmentType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxAccountCredentialDetails"/>. </summary>
        /// <param name="accountName"> Name of the account. </param>
        /// <param name="dataAccountType"> Type of the account. </param>
        /// <param name="accountConnectionString"> Connection string of the account endpoint to use the account as a storage endpoint on the device. </param>
        /// <param name="shareCredentialDetails"> Per share level unencrypted access credentials. </param>
        /// <returns> A new <see cref="Models.DataBoxAccountCredentialDetails"/> instance for mocking. </returns>
        public static DataBoxAccountCredentialDetails DataBoxAccountCredentialDetails(string accountName = null, DataAccountType? dataAccountType = null, string accountConnectionString = null, IEnumerable<ShareCredentialDetails> shareCredentialDetails = null)
        {
            shareCredentialDetails ??= new List<ShareCredentialDetails>();

            return new DataBoxAccountCredentialDetails(accountName, dataAccountType, accountConnectionString, shareCredentialDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ShareCredentialDetails"/>. </summary>
        /// <param name="shareName"> Name of the share. </param>
        /// <param name="shareType"> Type of the share. </param>
        /// <param name="userName"> User name for the share. </param>
        /// <param name="password"> Password for the share. </param>
        /// <param name="supportedAccessProtocols"> Access protocols supported on the device. </param>
        /// <returns> A new <see cref="Models.ShareCredentialDetails"/> instance for mocking. </returns>
        public static ShareCredentialDetails ShareCredentialDetails(string shareName = null, ShareDestinationFormatType? shareType = null, string userName = null, string password = null, IEnumerable<DataBoxAccessProtocol> supportedAccessProtocols = null)
        {
            supportedAccessProtocols ??= new List<DataBoxAccessProtocol>();

            return new ShareCredentialDetails(
                shareName,
                shareType,
                userName,
                password,
                supportedAccessProtocols?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceNetworkConfiguration"/>. </summary>
        /// <param name="name"> Name of the network. </param>
        /// <param name="macAddress"> Mac Address. </param>
        /// <returns> A new <see cref="Models.ApplianceNetworkConfiguration"/> instance for mocking. </returns>
        public static ApplianceNetworkConfiguration ApplianceNetworkConfiguration(string name = null, string macAddress = null)
        {
            return new ApplianceNetworkConfiguration(name, macAddress, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxCustomerDiskCopyProgress"/>. </summary>
        /// <param name="storageAccountName"> Name of the storage account. This will be empty for data account types other than storage account. </param>
        /// <param name="transferType"> Transfer type of data. </param>
        /// <param name="dataAccountType"> Data Account Type. </param>
        /// <param name="accountId"> Id of the account where the data needs to be uploaded. </param>
        /// <param name="bytesProcessed"> To indicate bytes transferred. </param>
        /// <param name="totalBytesToProcess"> Total amount of data to be processed by the job. </param>
        /// <param name="filesProcessed"> Number of files processed. </param>
        /// <param name="totalFilesToProcess"> Total files to process. </param>
        /// <param name="invalidFilesProcessed"> Number of files not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="invalidFileBytesUploaded"> Total amount of data not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="renamedContainerCount"> Number of folders not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="filesErroredOut"> Number of files which could not be copied. </param>
        /// <param name="directoriesErroredOut"> To indicate directories errored out in the job. </param>
        /// <param name="invalidDirectoriesProcessed"> To indicate directories renamed. </param>
        /// <param name="isEnumerationInProgress">
        /// To indicate if enumeration of data is in progress.
        /// Until this is true, the TotalBytesToProcess may not be valid.
        /// </param>
        /// <param name="error"> Error, if any, in the stage. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <param name="serialNumber"> Disk Serial Number. </param>
        /// <param name="copyStatus"> The Status of the copy. </param>
        /// <returns> A new <see cref="Models.DataBoxCustomerDiskCopyProgress"/> instance for mocking. </returns>
        public static DataBoxCustomerDiskCopyProgress DataBoxCustomerDiskCopyProgress(string storageAccountName = null, DataBoxJobTransferType? transferType = null, DataAccountType? dataAccountType = null, ResourceIdentifier accountId = null, long? bytesProcessed = null, long? totalBytesToProcess = null, long? filesProcessed = null, long? totalFilesToProcess = null, long? invalidFilesProcessed = null, long? invalidFileBytesUploaded = null, long? renamedContainerCount = null, long? filesErroredOut = null, long? directoriesErroredOut = null, long? invalidDirectoriesProcessed = null, bool? isEnumerationInProgress = null, ResponseError error = null, IEnumerable<CustomerResolutionCode> actions = null, string serialNumber = null, DataBoxCopyStatus? copyStatus = null)
        {
            actions ??= new List<CustomerResolutionCode>();

            return new DataBoxCustomerDiskCopyProgress(
                storageAccountName,
                transferType,
                dataAccountType,
                accountId,
                bytesProcessed,
                totalBytesToProcess,
                filesProcessed,
                totalFilesToProcess,
                invalidFilesProcessed,
                invalidFileBytesUploaded,
                renamedContainerCount,
                filesErroredOut,
                directoriesErroredOut,
                invalidDirectoriesProcessed,
                isEnumerationInProgress,
                error,
                actions?.ToList(),
                serializedAdditionalRawData: null,
                serialNumber,
                copyStatus);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxCopyProgress"/>. </summary>
        /// <param name="storageAccountName"> Name of the storage account. This will be empty for data account types other than storage account. </param>
        /// <param name="transferType"> Transfer type of data. </param>
        /// <param name="dataAccountType"> Data Account Type. </param>
        /// <param name="accountId"> Id of the account where the data needs to be uploaded. </param>
        /// <param name="bytesProcessed"> To indicate bytes transferred. </param>
        /// <param name="totalBytesToProcess"> Total amount of data to be processed by the job. </param>
        /// <param name="filesProcessed"> Number of files processed. </param>
        /// <param name="totalFilesToProcess"> Total files to process. </param>
        /// <param name="invalidFilesProcessed"> Number of files not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="invalidFileBytesUploaded"> Total amount of data not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="renamedContainerCount"> Number of folders not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="filesErroredOut"> Number of files which could not be copied. </param>
        /// <param name="directoriesErroredOut"> To indicate directories errored out in the job. </param>
        /// <param name="invalidDirectoriesProcessed"> To indicate directories renamed. </param>
        /// <param name="isEnumerationInProgress">
        /// To indicate if enumeration of data is in progress.
        /// Until this is true, the TotalBytesToProcess may not be valid.
        /// </param>
        /// <param name="error"> Error, if any, in the stage. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <returns> A new <see cref="Models.DataBoxCopyProgress"/> instance for mocking. </returns>
        public static DataBoxCopyProgress DataBoxCopyProgress(string storageAccountName = null, DataBoxJobTransferType? transferType = null, DataAccountType? dataAccountType = null, ResourceIdentifier accountId = null, long? bytesProcessed = null, long? totalBytesToProcess = null, long? filesProcessed = null, long? totalFilesToProcess = null, long? invalidFilesProcessed = null, long? invalidFileBytesUploaded = null, long? renamedContainerCount = null, long? filesErroredOut = null, long? directoriesErroredOut = null, long? invalidDirectoriesProcessed = null, bool? isEnumerationInProgress = null, ResponseError error = null, IEnumerable<CustomerResolutionCode> actions = null)
        {
            actions ??= new List<CustomerResolutionCode>();

            return new DataBoxCopyProgress(
                storageAccountName,
                transferType,
                dataAccountType,
                accountId,
                bytesProcessed,
                totalBytesToProcess,
                filesProcessed,
                totalFilesToProcess,
                invalidFilesProcessed,
                invalidFileBytesUploaded,
                renamedContainerCount,
                filesErroredOut,
                directoriesErroredOut,
                invalidDirectoriesProcessed,
                isEnumerationInProgress,
                error,
                actions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GranularCopyProgress"/>. </summary>
        /// <param name="storageAccountName"> Name of the storage account. This will be empty for data account types other than storage account. </param>
        /// <param name="transferType"> Transfer type of data. </param>
        /// <param name="dataAccountType"> Data Account Type. </param>
        /// <param name="accountId"> Id of the account where the data needs to be uploaded. </param>
        /// <param name="bytesProcessed"> To indicate bytes transferred. </param>
        /// <param name="totalBytesToProcess"> Total amount of data to be processed by the job. </param>
        /// <param name="filesProcessed"> Number of files processed. </param>
        /// <param name="totalFilesToProcess"> Total files to process. </param>
        /// <param name="invalidFilesProcessed"> Number of files not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="invalidFileBytesUploaded"> Total amount of data not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="renamedContainerCount"> Number of folders not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="filesErroredOut"> Number of files which could not be copied. </param>
        /// <param name="directoriesErroredOut"> To indicate directories errored out in the job. </param>
        /// <param name="invalidDirectoriesProcessed"> To indicate directories renamed. </param>
        /// <param name="isEnumerationInProgress">
        /// To indicate if enumeration of data is in progress.
        /// Until this is true, the TotalBytesToProcess may not be valid.
        /// </param>
        /// <param name="error"> Error, if any, in the stage. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <returns> A new <see cref="Models.GranularCopyProgress"/> instance for mocking. </returns>
        public static GranularCopyProgress GranularCopyProgress(string storageAccountName = null, DataBoxJobTransferType? transferType = null, DataAccountType? dataAccountType = null, ResourceIdentifier accountId = null, long? bytesProcessed = null, long? totalBytesToProcess = null, long? filesProcessed = null, long? totalFilesToProcess = null, long? invalidFilesProcessed = null, long? invalidFileBytesUploaded = null, long? renamedContainerCount = null, long? filesErroredOut = null, long? directoriesErroredOut = null, long? invalidDirectoriesProcessed = null, bool? isEnumerationInProgress = null, ResponseError error = null, IEnumerable<CustomerResolutionCode> actions = null)
        {
            actions ??= new List<CustomerResolutionCode>();

            return new GranularCopyProgress(
                storageAccountName,
                transferType,
                dataAccountType,
                accountId,
                bytesProcessed,
                totalBytesToProcess,
                filesProcessed,
                totalFilesToProcess,
                invalidFilesProcessed,
                invalidFileBytesUploaded,
                renamedContainerCount,
                filesErroredOut,
                directoriesErroredOut,
                invalidDirectoriesProcessed,
                isEnumerationInProgress,
                error,
                actions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CreateOrderLimitForSubscriptionValidationContent"/>. </summary>
        /// <param name="deviceType"> Device type to be used for the job. </param>
        /// <returns> A new <see cref="Models.CreateOrderLimitForSubscriptionValidationContent"/> instance for mocking. </returns>
        public static CreateOrderLimitForSubscriptionValidationContent CreateOrderLimitForSubscriptionValidationContent(DataBoxSkuName deviceType = default)
        {
            return new CreateOrderLimitForSubscriptionValidationContent(DataBoxValidationInputDiscriminator.ValidateCreateOrderLimit, serializedAdditionalRawData: null, deviceType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CreateOrderLimitForSubscriptionValidationResult"/>. </summary>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="status"> Create order limit validation status. </param>
        /// <returns> A new <see cref="Models.CreateOrderLimitForSubscriptionValidationResult"/> instance for mocking. </returns>
        public static CreateOrderLimitForSubscriptionValidationResult CreateOrderLimitForSubscriptionValidationResult(ResponseError error = null, DataBoxValidationStatus? status = null)
        {
            return new CreateOrderLimitForSubscriptionValidationResult(DataBoxValidationInputDiscriminator.ValidateCreateOrderLimit, error, serializedAdditionalRawData: null, status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxCustomerDiskJobDetails"/>. </summary>
        /// <param name="jobStages"> List of stages that run in the job. </param>
        /// <param name="contactDetails"> Contact details for notification and shipping. </param>
        /// <param name="shippingAddress"> Shipping address of the customer. </param>
        /// <param name="deliveryPackage"> Delivery package shipping details. </param>
        /// <param name="returnPackage"> Return package shipping details. </param>
        /// <param name="dataImportDetails"> Details of the data to be imported into azure. </param>
        /// <param name="dataExportDetails"> Details of the data to be exported from azure. </param>
        /// <param name="preferences"> Preferences for the order. </param>
        /// <param name="reverseShippingDetails"> Optional Reverse Shipping details for order. </param>
        /// <param name="copyLogDetails">
        /// List of copy log details.
        /// Please note <see cref="CopyLogDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataBoxAccountCopyLogDetails"/>, <see cref="Models.DataBoxCustomerDiskCopyLogDetails"/>, <see cref="Models.DataBoxDiskCopyLogDetails"/> and <see cref="Models.DataBoxHeavyAccountCopyLogDetails"/>.
        /// </param>
        /// <param name="reverseShipmentLabelSasKey"> Shared access key to download the return shipment label. </param>
        /// <param name="chainOfCustodySasKey"> Shared access key to download the chain of custody logs. </param>
        /// <param name="deviceErasureDetails"> Holds device data erasure details. </param>
        /// <param name="keyEncryptionKey"> Details about which key encryption type is being used. </param>
        /// <param name="expectedDataSizeInTerabytes"> The expected size of the data, which needs to be transferred in this job, in terabytes. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <param name="lastMitigationActionOnJob"> Last mitigation action performed on the job. </param>
        /// <param name="dataCenterAddress">
        /// Datacenter address to ship to, for the given sku and storage location.
        /// Please note <see cref="Models.DataCenterAddressResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataCenterAddressInstructionResult"/> and <see cref="Models.DataCenterAddressLocationResult"/>.
        /// </param>
        /// <param name="dataCenterCode"> DataCenter code. </param>
        /// <param name="importDiskDetails"> Contains the map of disk serial number to the disk details for import jobs. </param>
        /// <param name="exportDiskDetails"> Contains the map of disk serial number to the disk details for export jobs. </param>
        /// <param name="copyProgress"> Copy progress per disk. </param>
        /// <param name="deliverToDataCenterPackageDetails"> Delivery package shipping details. </param>
        /// <param name="returnToCustomerPackageDetails"> Return package shipping details. </param>
        /// <param name="enableManifestBackup"> Flag to indicate if disk manifest should be backed-up in the Storage Account. </param>
        /// <returns> A new <see cref="Models.DataBoxCustomerDiskJobDetails"/> instance for mocking. </returns>
        public static DataBoxCustomerDiskJobDetails DataBoxCustomerDiskJobDetails(IEnumerable<DataBoxJobStage> jobStages = null, DataBoxContactDetails contactDetails = null, DataBoxShippingAddress shippingAddress = null, PackageShippingDetails deliveryPackage = null, PackageShippingDetails returnPackage = null, IEnumerable<DataImportDetails> dataImportDetails = null, IEnumerable<DataExportDetails> dataExportDetails = null, DataBoxOrderPreferences preferences = null, ReverseShippingDetails reverseShippingDetails = null, IEnumerable<CopyLogDetails> copyLogDetails = null, string reverseShipmentLabelSasKey = null, string chainOfCustodySasKey = null, DeviceErasureDetails deviceErasureDetails = null, DataBoxKeyEncryptionKey keyEncryptionKey = null, int? expectedDataSizeInTerabytes = null, IEnumerable<CustomerResolutionCode> actions = null, LastMitigationActionOnJob lastMitigationActionOnJob = null, DataCenterAddressResult dataCenterAddress = null, DataCenterCode? dataCenterCode = null, IDictionary<string, ImportDiskDetails> importDiskDetails = null, IReadOnlyDictionary<string, ExportDiskDetails> exportDiskDetails = null, IEnumerable<DataBoxCustomerDiskCopyProgress> copyProgress = null, PackageCarrierInfo deliverToDataCenterPackageDetails = null, PackageCarrierDetails returnToCustomerPackageDetails = null, bool? enableManifestBackup = null)
        {
            jobStages ??= new List<DataBoxJobStage>();
            dataImportDetails ??= new List<DataImportDetails>();
            dataExportDetails ??= new List<DataExportDetails>();
            copyLogDetails ??= new List<CopyLogDetails>();
            actions ??= new List<CustomerResolutionCode>();
            importDiskDetails ??= new Dictionary<string, ImportDiskDetails>();
            exportDiskDetails ??= new Dictionary<string, ExportDiskDetails>();
            copyProgress ??= new List<DataBoxCustomerDiskCopyProgress>();

            return new DataBoxCustomerDiskJobDetails(
                jobStages?.ToList(),
                contactDetails,
                shippingAddress,
                deliveryPackage,
                returnPackage,
                dataImportDetails?.ToList(),
                dataExportDetails?.ToList(),
                DataBoxOrderType.DataBoxCustomerDisk,
                preferences,
                reverseShippingDetails,
                copyLogDetails?.ToList(),
                reverseShipmentLabelSasKey,
                chainOfCustodySasKey,
                deviceErasureDetails,
                keyEncryptionKey,
                expectedDataSizeInTerabytes,
                actions?.ToList(),
                lastMitigationActionOnJob,
                dataCenterAddress,
                dataCenterCode,
                serializedAdditionalRawData: null,
                importDiskDetails,
                exportDiskDetails,
                copyProgress?.ToList(),
                deliverToDataCenterPackageDetails,
                returnToCustomerPackageDetails,
                enableManifestBackup);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ImportDiskDetails"/>. </summary>
        /// <param name="manifestFile"> The relative path of the manifest file on the disk. </param>
        /// <param name="manifestHash"> The Base16-encoded MD5 hash of the manifest file on the disk. </param>
        /// <param name="bitLockerKey"> BitLocker key used to encrypt the disk. </param>
        /// <param name="backupManifestCloudPath"> Path to backed up manifest, only returned if enableManifestBackup is true. </param>
        /// <returns> A new <see cref="Models.ImportDiskDetails"/> instance for mocking. </returns>
        public static ImportDiskDetails ImportDiskDetails(string manifestFile = null, string manifestHash = null, string bitLockerKey = null, string backupManifestCloudPath = null)
        {
            return new ImportDiskDetails(manifestFile, manifestHash, bitLockerKey, backupManifestCloudPath, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExportDiskDetails"/>. </summary>
        /// <param name="manifestFile"> The relative path of the manifest file on the disk. </param>
        /// <param name="manifestHash"> The Base16-encoded MD5 hash of the manifest file on the disk. </param>
        /// <param name="backupManifestCloudPath"> Path to backed up manifest, only returned if enableManifestBackup is true. </param>
        /// <returns> A new <see cref="Models.ExportDiskDetails"/> instance for mocking. </returns>
        public static ExportDiskDetails ExportDiskDetails(string manifestFile = null, string manifestHash = null, string backupManifestCloudPath = null)
        {
            return new ExportDiskDetails(manifestFile, manifestHash, backupManifestCloudPath, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CustomerDiskJobSecrets"/>. </summary>
        /// <param name="dataCenterAccessSecurityCode"> Dc Access Security Code for Customer Managed Shipping. </param>
        /// <param name="error"> Error while fetching the secrets. </param>
        /// <param name="diskSecrets"> Contains the list of secrets object for that device. </param>
        /// <param name="carrierAccountNumber"> Carrier Account Number of the customer. </param>
        /// <returns> A new <see cref="Models.CustomerDiskJobSecrets"/> instance for mocking. </returns>
        public static CustomerDiskJobSecrets CustomerDiskJobSecrets(DataCenterAccessSecurityCode dataCenterAccessSecurityCode = null, ResponseError error = null, IEnumerable<DataBoxDiskSecret> diskSecrets = null, string carrierAccountNumber = null)
        {
            diskSecrets ??= new List<DataBoxDiskSecret>();

            return new CustomerDiskJobSecrets(
                DataBoxOrderType.DataBoxCustomerDisk,
                dataCenterAccessSecurityCode,
                error,
                serializedAdditionalRawData: null,
                diskSecrets?.ToList(),
                carrierAccountNumber);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxDiskSecret"/>. </summary>
        /// <param name="diskSerialNumber"> Serial number of the assigned disk. </param>
        /// <param name="bitLockerKey"> Bit Locker key of the disk which can be used to unlock the disk to copy data. </param>
        /// <returns> A new <see cref="Models.DataBoxDiskSecret"/> instance for mocking. </returns>
        public static DataBoxDiskSecret DataBoxDiskSecret(string diskSerialNumber = null, string bitLockerKey = null)
        {
            return new DataBoxDiskSecret(diskSerialNumber, bitLockerKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCenterAddressInstructionResult"/>. </summary>
        /// <param name="supportedCarriersForReturnShipment"> List of supported carriers for return shipment. </param>
        /// <param name="dataCenterAzureLocation"> Azure Location where the Data Center serves primarily. </param>
        /// <param name="communicationInstruction"> Data center communication instruction. </param>
        /// <returns> A new <see cref="Models.DataCenterAddressInstructionResult"/> instance for mocking. </returns>
        public static DataCenterAddressInstructionResult DataCenterAddressInstructionResult(IEnumerable<string> supportedCarriersForReturnShipment = null, AzureLocation? dataCenterAzureLocation = null, string communicationInstruction = null)
        {
            supportedCarriersForReturnShipment ??= new List<string>();

            return new DataCenterAddressInstructionResult(DataCenterAddressType.DataCenterAddressInstruction, supportedCarriersForReturnShipment?.ToList(), dataCenterAzureLocation, serializedAdditionalRawData: null, communicationInstruction);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCenterAddressLocationResult"/>. </summary>
        /// <param name="supportedCarriersForReturnShipment"> List of supported carriers for return shipment. </param>
        /// <param name="dataCenterAzureLocation"> Azure Location where the Data Center serves primarily. </param>
        /// <param name="contactPersonName"> Contact person name. </param>
        /// <param name="company"> Company name. </param>
        /// <param name="street1"> Street address line 1. </param>
        /// <param name="street2"> Street address line 2. </param>
        /// <param name="street3"> Street address line 3. </param>
        /// <param name="city"> City name. </param>
        /// <param name="state"> name of the state. </param>
        /// <param name="zip"> Zip code. </param>
        /// <param name="country"> name of the country. </param>
        /// <param name="phone"> Phone number. </param>
        /// <param name="phoneExtension"> Phone extension. </param>
        /// <param name="addressType"> Address type. </param>
        /// <param name="additionalShippingInformation"> Special instruction for shipping. </param>
        /// <returns> A new <see cref="Models.DataCenterAddressLocationResult"/> instance for mocking. </returns>
        public static DataCenterAddressLocationResult DataCenterAddressLocationResult(IEnumerable<string> supportedCarriersForReturnShipment = null, AzureLocation? dataCenterAzureLocation = null, string contactPersonName = null, string company = null, string street1 = null, string street2 = null, string street3 = null, string city = null, string state = null, string zip = null, string country = null, string phone = null, string phoneExtension = null, string addressType = null, string additionalShippingInformation = null)
        {
            supportedCarriersForReturnShipment ??= new List<string>();

            return new DataCenterAddressLocationResult(
                DataCenterAddressType.DataCenterAddressLocation,
                supportedCarriersForReturnShipment?.ToList(),
                dataCenterAzureLocation,
                serializedAdditionalRawData: null,
                contactPersonName,
                company,
                street1,
                street2,
                street3,
                city,
                state,
                zip,
                country,
                phone,
                phoneExtension,
                addressType,
                additionalShippingInformation);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxAccountCopyLogDetails"/>. </summary>
        /// <param name="accountName"> Account name. </param>
        /// <param name="copyLogLink"> Link for copy logs. </param>
        /// <param name="copyVerboseLogLink"> Link for copy verbose logs. This will be set only when LogCollectionLevel is set to Verbose. </param>
        /// <returns> A new <see cref="Models.DataBoxAccountCopyLogDetails"/> instance for mocking. </returns>
        public static DataBoxAccountCopyLogDetails DataBoxAccountCopyLogDetails(string accountName = null, string copyLogLink = null, string copyVerboseLogLink = null)
        {
            return new DataBoxAccountCopyLogDetails(DataBoxOrderType.DataBox, serializedAdditionalRawData: null, accountName, copyLogLink, copyVerboseLogLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxCustomerDiskCopyLogDetails"/>. </summary>
        /// <param name="serialNumber"> Disk Serial Number. </param>
        /// <param name="errorLogLink"> Link for copy error logs. </param>
        /// <param name="verboseLogLink"> Link for copy verbose logs. </param>
        /// <returns> A new <see cref="Models.DataBoxCustomerDiskCopyLogDetails"/> instance for mocking. </returns>
        public static DataBoxCustomerDiskCopyLogDetails DataBoxCustomerDiskCopyLogDetails(string serialNumber = null, string errorLogLink = null, string verboseLogLink = null)
        {
            return new DataBoxCustomerDiskCopyLogDetails(DataBoxOrderType.DataBoxCustomerDisk, serializedAdditionalRawData: null, serialNumber, errorLogLink, verboseLogLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxDiskCopyLogDetails"/>. </summary>
        /// <param name="diskSerialNumber"> Disk Serial Number. </param>
        /// <param name="errorLogLink"> Link for copy error logs. </param>
        /// <param name="verboseLogLink"> Link for copy verbose logs. </param>
        /// <returns> A new <see cref="Models.DataBoxDiskCopyLogDetails"/> instance for mocking. </returns>
        public static DataBoxDiskCopyLogDetails DataBoxDiskCopyLogDetails(string diskSerialNumber = null, string errorLogLink = null, string verboseLogLink = null)
        {
            return new DataBoxDiskCopyLogDetails(DataBoxOrderType.DataBoxDisk, serializedAdditionalRawData: null, diskSerialNumber, errorLogLink, verboseLogLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxDiskGranularCopyLogDetails"/>. </summary>
        /// <param name="serialNumber"> Disk Serial Number. </param>
        /// <param name="accountId"> Account id. </param>
        /// <param name="errorLogLink"> Link for copy error logs. </param>
        /// <param name="verboseLogLink"> Link for copy verbose logs. </param>
        /// <returns> A new <see cref="Models.DataBoxDiskGranularCopyLogDetails"/> instance for mocking. </returns>
        public static DataBoxDiskGranularCopyLogDetails DataBoxDiskGranularCopyLogDetails(string serialNumber = null, ResourceIdentifier accountId = null, string errorLogLink = null, string verboseLogLink = null)
        {
            return new DataBoxDiskGranularCopyLogDetails(
                DataBoxOrderType.DataBoxCustomerDisk,
                serializedAdditionalRawData: null,
                serialNumber,
                accountId,
                errorLogLink,
                verboseLogLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxDiskCopyProgress"/>. </summary>
        /// <param name="serialNumber"> The serial number of the disk. </param>
        /// <param name="bytesCopied"> Bytes copied during the copy of disk. </param>
        /// <param name="percentComplete"> Indicates the percentage completed for the copy of the disk. </param>
        /// <param name="status"> The Status of the copy. </param>
        /// <param name="error"> Error, if any, in the stage. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <returns> A new <see cref="Models.DataBoxDiskCopyProgress"/> instance for mocking. </returns>
        public static DataBoxDiskCopyProgress DataBoxDiskCopyProgress(string serialNumber = null, long? bytesCopied = null, int? percentComplete = null, DataBoxCopyStatus? status = null, ResponseError error = null, IEnumerable<CustomerResolutionCode> actions = null)
        {
            actions ??= new List<CustomerResolutionCode>();

            return new DataBoxDiskCopyProgress(
                serialNumber,
                bytesCopied,
                percentComplete,
                status,
                error,
                actions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxDiskGranularCopyProgress"/>. </summary>
        /// <param name="storageAccountName"> Name of the storage account. This will be empty for data account types other than storage account. </param>
        /// <param name="transferType"> Transfer type of data. </param>
        /// <param name="dataAccountType"> Data Account Type. </param>
        /// <param name="accountId"> Id of the account where the data needs to be uploaded. </param>
        /// <param name="bytesProcessed"> To indicate bytes transferred. </param>
        /// <param name="totalBytesToProcess"> Total amount of data to be processed by the job. </param>
        /// <param name="filesProcessed"> Number of files processed. </param>
        /// <param name="totalFilesToProcess"> Total files to process. </param>
        /// <param name="invalidFilesProcessed"> Number of files not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="invalidFileBytesUploaded"> Total amount of data not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="renamedContainerCount"> Number of folders not adhering to azure naming conventions which were processed by automatic renaming. </param>
        /// <param name="filesErroredOut"> Number of files which could not be copied. </param>
        /// <param name="directoriesErroredOut"> To indicate directories errored out in the job. </param>
        /// <param name="invalidDirectoriesProcessed"> To indicate directories renamed. </param>
        /// <param name="isEnumerationInProgress">
        /// To indicate if enumeration of data is in progress.
        /// Until this is true, the TotalBytesToProcess may not be valid.
        /// </param>
        /// <param name="error"> Error, if any, in the stage. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <param name="serialNumber"> Disk Serial Number. </param>
        /// <param name="copyStatus"> The Status of the copy. </param>
        /// <returns> A new <see cref="Models.DataBoxDiskGranularCopyProgress"/> instance for mocking. </returns>
        public static DataBoxDiskGranularCopyProgress DataBoxDiskGranularCopyProgress(string storageAccountName = null, DataBoxJobTransferType? transferType = null, DataAccountType? dataAccountType = null, ResourceIdentifier accountId = null, long? bytesProcessed = null, long? totalBytesToProcess = null, long? filesProcessed = null, long? totalFilesToProcess = null, long? invalidFilesProcessed = null, long? invalidFileBytesUploaded = null, long? renamedContainerCount = null, long? filesErroredOut = null, long? directoriesErroredOut = null, long? invalidDirectoriesProcessed = null, bool? isEnumerationInProgress = null, ResponseError error = null, IEnumerable<CustomerResolutionCode> actions = null, string serialNumber = null, DataBoxCopyStatus? copyStatus = null)
        {
            actions ??= new List<CustomerResolutionCode>();

            return new DataBoxDiskGranularCopyProgress(
                storageAccountName,
                transferType,
                dataAccountType,
                accountId,
                bytesProcessed,
                totalBytesToProcess,
                filesProcessed,
                totalFilesToProcess,
                invalidFilesProcessed,
                invalidFileBytesUploaded,
                renamedContainerCount,
                filesErroredOut,
                directoriesErroredOut,
                invalidDirectoriesProcessed,
                isEnumerationInProgress,
                error,
                actions?.ToList(),
                serializedAdditionalRawData: null,
                serialNumber,
                copyStatus);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxDiskJobDetails"/>. </summary>
        /// <param name="jobStages"> List of stages that run in the job. </param>
        /// <param name="contactDetails"> Contact details for notification and shipping. </param>
        /// <param name="shippingAddress"> Shipping address of the customer. </param>
        /// <param name="deliveryPackage"> Delivery package shipping details. </param>
        /// <param name="returnPackage"> Return package shipping details. </param>
        /// <param name="dataImportDetails"> Details of the data to be imported into azure. </param>
        /// <param name="dataExportDetails"> Details of the data to be exported from azure. </param>
        /// <param name="preferences"> Preferences for the order. </param>
        /// <param name="reverseShippingDetails"> Optional Reverse Shipping details for order. </param>
        /// <param name="copyLogDetails">
        /// List of copy log details.
        /// Please note <see cref="CopyLogDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataBoxAccountCopyLogDetails"/>, <see cref="Models.DataBoxCustomerDiskCopyLogDetails"/>, <see cref="Models.DataBoxDiskCopyLogDetails"/> and <see cref="Models.DataBoxHeavyAccountCopyLogDetails"/>.
        /// </param>
        /// <param name="reverseShipmentLabelSasKey"> Shared access key to download the return shipment label. </param>
        /// <param name="chainOfCustodySasKey"> Shared access key to download the chain of custody logs. </param>
        /// <param name="deviceErasureDetails"> Holds device data erasure details. </param>
        /// <param name="keyEncryptionKey"> Details about which key encryption type is being used. </param>
        /// <param name="expectedDataSizeInTerabytes"> The expected size of the data, which needs to be transferred in this job, in terabytes. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <param name="lastMitigationActionOnJob"> Last mitigation action performed on the job. </param>
        /// <param name="dataCenterAddress">
        /// Datacenter address to ship to, for the given sku and storage location.
        /// Please note <see cref="Models.DataCenterAddressResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataCenterAddressInstructionResult"/> and <see cref="Models.DataCenterAddressLocationResult"/>.
        /// </param>
        /// <param name="dataCenterCode"> DataCenter code. </param>
        /// <param name="preferredDisks"> User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int. </param>
        /// <param name="copyProgress"> Copy progress per disk. </param>
        /// <param name="granularCopyProgress"> Copy progress per disk. </param>
        /// <param name="granularCopyLogDetails"> Copy progress per disk. </param>
        /// <param name="disksAndSizeDetails"> Contains the map of disk serial number to the disk size being used for the job. Is returned only after the disks are shipped to the customer. </param>
        /// <param name="passkey"> User entered passkey for DataBox Disk job. </param>
        /// <returns> A new <see cref="Models.DataBoxDiskJobDetails"/> instance for mocking. </returns>
        public static DataBoxDiskJobDetails DataBoxDiskJobDetails(IEnumerable<DataBoxJobStage> jobStages = null, DataBoxContactDetails contactDetails = null, DataBoxShippingAddress shippingAddress = null, PackageShippingDetails deliveryPackage = null, PackageShippingDetails returnPackage = null, IEnumerable<DataImportDetails> dataImportDetails = null, IEnumerable<DataExportDetails> dataExportDetails = null, DataBoxOrderPreferences preferences = null, ReverseShippingDetails reverseShippingDetails = null, IEnumerable<CopyLogDetails> copyLogDetails = null, string reverseShipmentLabelSasKey = null, string chainOfCustodySasKey = null, DeviceErasureDetails deviceErasureDetails = null, DataBoxKeyEncryptionKey keyEncryptionKey = null, int? expectedDataSizeInTerabytes = null, IEnumerable<CustomerResolutionCode> actions = null, LastMitigationActionOnJob lastMitigationActionOnJob = null, DataCenterAddressResult dataCenterAddress = null, DataCenterCode? dataCenterCode = null, IDictionary<string, int> preferredDisks = null, IEnumerable<DataBoxDiskCopyProgress> copyProgress = null, IEnumerable<DataBoxDiskGranularCopyProgress> granularCopyProgress = null, IEnumerable<DataBoxDiskGranularCopyLogDetails> granularCopyLogDetails = null, IReadOnlyDictionary<string, int> disksAndSizeDetails = null, string passkey = null)
        {
            jobStages ??= new List<DataBoxJobStage>();
            dataImportDetails ??= new List<DataImportDetails>();
            dataExportDetails ??= new List<DataExportDetails>();
            copyLogDetails ??= new List<CopyLogDetails>();
            actions ??= new List<CustomerResolutionCode>();
            preferredDisks ??= new Dictionary<string, int>();
            copyProgress ??= new List<DataBoxDiskCopyProgress>();
            granularCopyProgress ??= new List<DataBoxDiskGranularCopyProgress>();
            granularCopyLogDetails ??= new List<DataBoxDiskGranularCopyLogDetails>();
            disksAndSizeDetails ??= new Dictionary<string, int>();

            return new DataBoxDiskJobDetails(
                jobStages?.ToList(),
                contactDetails,
                shippingAddress,
                deliveryPackage,
                returnPackage,
                dataImportDetails?.ToList(),
                dataExportDetails?.ToList(),
                DataBoxOrderType.DataBoxDisk,
                preferences,
                reverseShippingDetails,
                copyLogDetails?.ToList(),
                reverseShipmentLabelSasKey,
                chainOfCustodySasKey,
                deviceErasureDetails,
                keyEncryptionKey,
                expectedDataSizeInTerabytes,
                actions?.ToList(),
                lastMitigationActionOnJob,
                dataCenterAddress,
                dataCenterCode,
                serializedAdditionalRawData: null,
                preferredDisks,
                copyProgress?.ToList(),
                granularCopyProgress?.ToList(),
                granularCopyLogDetails?.ToList(),
                disksAndSizeDetails,
                passkey);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxDiskJobSecrets"/>. </summary>
        /// <param name="dataCenterAccessSecurityCode"> Dc Access Security Code for Customer Managed Shipping. </param>
        /// <param name="error"> Error while fetching the secrets. </param>
        /// <param name="diskSecrets"> Contains the list of secrets object for that device. </param>
        /// <param name="passkey"> PassKey for the disk Job. </param>
        /// <param name="isPasskeyUserDefined"> Whether passkey was provided by user. </param>
        /// <returns> A new <see cref="Models.DataBoxDiskJobSecrets"/> instance for mocking. </returns>
        public static DataBoxDiskJobSecrets DataBoxDiskJobSecrets(DataCenterAccessSecurityCode dataCenterAccessSecurityCode = null, ResponseError error = null, IEnumerable<DataBoxDiskSecret> diskSecrets = null, string passkey = null, bool? isPasskeyUserDefined = null)
        {
            diskSecrets ??= new List<DataBoxDiskSecret>();

            return new DataBoxDiskJobSecrets(
                DataBoxOrderType.DataBoxDisk,
                dataCenterAccessSecurityCode,
                error,
                serializedAdditionalRawData: null,
                diskSecrets?.ToList(),
                passkey,
                isPasskeyUserDefined);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxHeavyAccountCopyLogDetails"/>. </summary>
        /// <param name="accountName"> Account name. </param>
        /// <param name="copyLogLink"> Link for copy logs. </param>
        /// <param name="copyVerboseLogLink"> Link for copy verbose logs. This will be set only when the LogCollectionLevel is set to verbose. </param>
        /// <returns> A new <see cref="Models.DataBoxHeavyAccountCopyLogDetails"/> instance for mocking. </returns>
        public static DataBoxHeavyAccountCopyLogDetails DataBoxHeavyAccountCopyLogDetails(string accountName = null, IEnumerable<string> copyLogLink = null, IEnumerable<string> copyVerboseLogLink = null)
        {
            copyLogLink ??= new List<string>();
            copyVerboseLogLink ??= new List<string>();

            return new DataBoxHeavyAccountCopyLogDetails(DataBoxOrderType.DataBoxHeavy, serializedAdditionalRawData: null, accountName, copyLogLink?.ToList(), copyVerboseLogLink?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxHeavyJobDetails"/>. </summary>
        /// <param name="jobStages"> List of stages that run in the job. </param>
        /// <param name="contactDetails"> Contact details for notification and shipping. </param>
        /// <param name="shippingAddress"> Shipping address of the customer. </param>
        /// <param name="deliveryPackage"> Delivery package shipping details. </param>
        /// <param name="returnPackage"> Return package shipping details. </param>
        /// <param name="dataImportDetails"> Details of the data to be imported into azure. </param>
        /// <param name="dataExportDetails"> Details of the data to be exported from azure. </param>
        /// <param name="preferences"> Preferences for the order. </param>
        /// <param name="reverseShippingDetails"> Optional Reverse Shipping details for order. </param>
        /// <param name="copyLogDetails">
        /// List of copy log details.
        /// Please note <see cref="CopyLogDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataBoxAccountCopyLogDetails"/>, <see cref="Models.DataBoxCustomerDiskCopyLogDetails"/>, <see cref="Models.DataBoxDiskCopyLogDetails"/> and <see cref="Models.DataBoxHeavyAccountCopyLogDetails"/>.
        /// </param>
        /// <param name="reverseShipmentLabelSasKey"> Shared access key to download the return shipment label. </param>
        /// <param name="chainOfCustodySasKey"> Shared access key to download the chain of custody logs. </param>
        /// <param name="deviceErasureDetails"> Holds device data erasure details. </param>
        /// <param name="keyEncryptionKey"> Details about which key encryption type is being used. </param>
        /// <param name="expectedDataSizeInTerabytes"> The expected size of the data, which needs to be transferred in this job, in terabytes. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <param name="lastMitigationActionOnJob"> Last mitigation action performed on the job. </param>
        /// <param name="dataCenterAddress">
        /// Datacenter address to ship to, for the given sku and storage location.
        /// Please note <see cref="Models.DataCenterAddressResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataCenterAddressInstructionResult"/> and <see cref="Models.DataCenterAddressLocationResult"/>.
        /// </param>
        /// <param name="dataCenterCode"> DataCenter code. </param>
        /// <param name="copyProgress"> Copy progress per account. </param>
        /// <param name="devicePassword"> Set Device password for unlocking Databox Heavy. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+. </param>
        /// <returns> A new <see cref="Models.DataBoxHeavyJobDetails"/> instance for mocking. </returns>
        public static DataBoxHeavyJobDetails DataBoxHeavyJobDetails(IEnumerable<DataBoxJobStage> jobStages = null, DataBoxContactDetails contactDetails = null, DataBoxShippingAddress shippingAddress = null, PackageShippingDetails deliveryPackage = null, PackageShippingDetails returnPackage = null, IEnumerable<DataImportDetails> dataImportDetails = null, IEnumerable<DataExportDetails> dataExportDetails = null, DataBoxOrderPreferences preferences = null, ReverseShippingDetails reverseShippingDetails = null, IEnumerable<CopyLogDetails> copyLogDetails = null, string reverseShipmentLabelSasKey = null, string chainOfCustodySasKey = null, DeviceErasureDetails deviceErasureDetails = null, DataBoxKeyEncryptionKey keyEncryptionKey = null, int? expectedDataSizeInTerabytes = null, IEnumerable<CustomerResolutionCode> actions = null, LastMitigationActionOnJob lastMitigationActionOnJob = null, DataCenterAddressResult dataCenterAddress = null, DataCenterCode? dataCenterCode = null, IEnumerable<DataBoxCopyProgress> copyProgress = null, string devicePassword = null)
        {
            jobStages ??= new List<DataBoxJobStage>();
            dataImportDetails ??= new List<DataImportDetails>();
            dataExportDetails ??= new List<DataExportDetails>();
            copyLogDetails ??= new List<CopyLogDetails>();
            actions ??= new List<CustomerResolutionCode>();
            copyProgress ??= new List<DataBoxCopyProgress>();

            return new DataBoxHeavyJobDetails(
                jobStages?.ToList(),
                contactDetails,
                shippingAddress,
                deliveryPackage,
                returnPackage,
                dataImportDetails?.ToList(),
                dataExportDetails?.ToList(),
                DataBoxOrderType.DataBoxHeavy,
                preferences,
                reverseShippingDetails,
                copyLogDetails?.ToList(),
                reverseShipmentLabelSasKey,
                chainOfCustodySasKey,
                deviceErasureDetails,
                keyEncryptionKey,
                expectedDataSizeInTerabytes,
                actions?.ToList(),
                lastMitigationActionOnJob,
                dataCenterAddress,
                dataCenterCode,
                serializedAdditionalRawData: null,
                copyProgress?.ToList(),
                devicePassword);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxHeavyJobSecrets"/>. </summary>
        /// <param name="dataCenterAccessSecurityCode"> Dc Access Security Code for Customer Managed Shipping. </param>
        /// <param name="error"> Error while fetching the secrets. </param>
        /// <param name="cabinetPodSecrets"> Contains the list of secret objects for a databox heavy job. </param>
        /// <returns> A new <see cref="Models.DataBoxHeavyJobSecrets"/> instance for mocking. </returns>
        public static DataBoxHeavyJobSecrets DataBoxHeavyJobSecrets(DataCenterAccessSecurityCode dataCenterAccessSecurityCode = null, ResponseError error = null, IEnumerable<DataBoxHeavySecret> cabinetPodSecrets = null)
        {
            cabinetPodSecrets ??= new List<DataBoxHeavySecret>();

            return new DataBoxHeavyJobSecrets(DataBoxOrderType.DataBoxHeavy, dataCenterAccessSecurityCode, error, serializedAdditionalRawData: null, cabinetPodSecrets?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxHeavySecret"/>. </summary>
        /// <param name="deviceSerialNumber"> Serial number of the assigned device. </param>
        /// <param name="devicePassword"> Password for out of the box experience on device. </param>
        /// <param name="networkConfigurations"> Network configuration of the appliance. </param>
        /// <param name="encodedValidationCertPubKey"> The base 64 encoded public key to authenticate with the device. </param>
        /// <param name="accountCredentialDetails"> Per account level access credentials. </param>
        /// <returns> A new <see cref="Models.DataBoxHeavySecret"/> instance for mocking. </returns>
        public static DataBoxHeavySecret DataBoxHeavySecret(string deviceSerialNumber = null, string devicePassword = null, IEnumerable<ApplianceNetworkConfiguration> networkConfigurations = null, string encodedValidationCertPubKey = null, IEnumerable<DataBoxAccountCredentialDetails> accountCredentialDetails = null)
        {
            networkConfigurations ??= new List<ApplianceNetworkConfiguration>();
            accountCredentialDetails ??= new List<DataBoxAccountCredentialDetails>();

            return new DataBoxHeavySecret(
                deviceSerialNumber,
                devicePassword,
                networkConfigurations?.ToList(),
                encodedValidationCertPubKey,
                accountCredentialDetails?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxJobDetails"/>. </summary>
        /// <param name="jobStages"> List of stages that run in the job. </param>
        /// <param name="contactDetails"> Contact details for notification and shipping. </param>
        /// <param name="shippingAddress"> Shipping address of the customer. </param>
        /// <param name="deliveryPackage"> Delivery package shipping details. </param>
        /// <param name="returnPackage"> Return package shipping details. </param>
        /// <param name="dataImportDetails"> Details of the data to be imported into azure. </param>
        /// <param name="dataExportDetails"> Details of the data to be exported from azure. </param>
        /// <param name="preferences"> Preferences for the order. </param>
        /// <param name="reverseShippingDetails"> Optional Reverse Shipping details for order. </param>
        /// <param name="copyLogDetails">
        /// List of copy log details.
        /// Please note <see cref="CopyLogDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataBoxAccountCopyLogDetails"/>, <see cref="Models.DataBoxCustomerDiskCopyLogDetails"/>, <see cref="Models.DataBoxDiskCopyLogDetails"/> and <see cref="Models.DataBoxHeavyAccountCopyLogDetails"/>.
        /// </param>
        /// <param name="reverseShipmentLabelSasKey"> Shared access key to download the return shipment label. </param>
        /// <param name="chainOfCustodySasKey"> Shared access key to download the chain of custody logs. </param>
        /// <param name="deviceErasureDetails"> Holds device data erasure details. </param>
        /// <param name="keyEncryptionKey"> Details about which key encryption type is being used. </param>
        /// <param name="expectedDataSizeInTerabytes"> The expected size of the data, which needs to be transferred in this job, in terabytes. </param>
        /// <param name="actions"> Available actions on the job. </param>
        /// <param name="lastMitigationActionOnJob"> Last mitigation action performed on the job. </param>
        /// <param name="dataCenterAddress">
        /// Datacenter address to ship to, for the given sku and storage location.
        /// Please note <see cref="Models.DataCenterAddressResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataCenterAddressInstructionResult"/> and <see cref="Models.DataCenterAddressLocationResult"/>.
        /// </param>
        /// <param name="dataCenterCode"> DataCenter code. </param>
        /// <param name="copyProgress"> Copy progress per storage account. </param>
        /// <param name="devicePassword"> Set Device password for unlocking Databox. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+. </param>
        /// <returns> A new <see cref="Models.DataBoxJobDetails"/> instance for mocking. </returns>
        public static DataBoxJobDetails DataBoxJobDetails(IEnumerable<DataBoxJobStage> jobStages = null, DataBoxContactDetails contactDetails = null, DataBoxShippingAddress shippingAddress = null, PackageShippingDetails deliveryPackage = null, PackageShippingDetails returnPackage = null, IEnumerable<DataImportDetails> dataImportDetails = null, IEnumerable<DataExportDetails> dataExportDetails = null, DataBoxOrderPreferences preferences = null, ReverseShippingDetails reverseShippingDetails = null, IEnumerable<CopyLogDetails> copyLogDetails = null, string reverseShipmentLabelSasKey = null, string chainOfCustodySasKey = null, DeviceErasureDetails deviceErasureDetails = null, DataBoxKeyEncryptionKey keyEncryptionKey = null, int? expectedDataSizeInTerabytes = null, IEnumerable<CustomerResolutionCode> actions = null, LastMitigationActionOnJob lastMitigationActionOnJob = null, DataCenterAddressResult dataCenterAddress = null, DataCenterCode? dataCenterCode = null, IEnumerable<DataBoxCopyProgress> copyProgress = null, string devicePassword = null)
        {
            jobStages ??= new List<DataBoxJobStage>();
            dataImportDetails ??= new List<DataImportDetails>();
            dataExportDetails ??= new List<DataExportDetails>();
            copyLogDetails ??= new List<CopyLogDetails>();
            actions ??= new List<CustomerResolutionCode>();
            copyProgress ??= new List<DataBoxCopyProgress>();

            return new DataBoxJobDetails(
                jobStages?.ToList(),
                contactDetails,
                shippingAddress,
                deliveryPackage,
                returnPackage,
                dataImportDetails?.ToList(),
                dataExportDetails?.ToList(),
                DataBoxOrderType.DataBox,
                preferences,
                reverseShippingDetails,
                copyLogDetails?.ToList(),
                reverseShipmentLabelSasKey,
                chainOfCustodySasKey,
                deviceErasureDetails,
                keyEncryptionKey,
                expectedDataSizeInTerabytes,
                actions?.ToList(),
                lastMitigationActionOnJob,
                dataCenterAddress,
                dataCenterCode,
                serializedAdditionalRawData: null,
                copyProgress?.ToList(),
                devicePassword);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataboxJobSecrets"/>. </summary>
        /// <param name="dataCenterAccessSecurityCode"> Dc Access Security Code for Customer Managed Shipping. </param>
        /// <param name="error"> Error while fetching the secrets. </param>
        /// <param name="podSecrets"> Contains the list of secret objects for a job. </param>
        /// <returns> A new <see cref="Models.DataboxJobSecrets"/> instance for mocking. </returns>
        public static DataboxJobSecrets DataboxJobSecrets(DataCenterAccessSecurityCode dataCenterAccessSecurityCode = null, ResponseError error = null, IEnumerable<DataBoxSecret> podSecrets = null)
        {
            podSecrets ??= new List<DataBoxSecret>();

            return new DataboxJobSecrets(DataBoxOrderType.DataBox, dataCenterAccessSecurityCode, error, serializedAdditionalRawData: null, podSecrets?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxSecret"/>. </summary>
        /// <param name="deviceSerialNumber"> Serial number of the assigned device. </param>
        /// <param name="devicePassword"> Password for out of the box experience on device. </param>
        /// <param name="networkConfigurations"> Network configuration of the appliance. </param>
        /// <param name="encodedValidationCertPubKey"> The base 64 encoded public key to authenticate with the device. </param>
        /// <param name="accountCredentialDetails"> Per account level access credentials. </param>
        /// <returns> A new <see cref="Models.DataBoxSecret"/> instance for mocking. </returns>
        public static DataBoxSecret DataBoxSecret(string deviceSerialNumber = null, string devicePassword = null, IEnumerable<ApplianceNetworkConfiguration> networkConfigurations = null, string encodedValidationCertPubKey = null, IEnumerable<DataBoxAccountCredentialDetails> accountCredentialDetails = null)
        {
            networkConfigurations ??= new List<ApplianceNetworkConfiguration>();
            accountCredentialDetails ??= new List<DataBoxAccountCredentialDetails>();

            return new DataBoxSecret(
                deviceSerialNumber,
                devicePassword,
                networkConfigurations?.ToList(),
                encodedValidationCertPubKey,
                accountCredentialDetails?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataBoxScheduleAvailabilityContent"/>. </summary>
        /// <param name="storageLocation"> Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01. </param>
        /// <param name="country"> Country in which storage location should be supported. </param>
        /// <returns> A new <see cref="Models.DataBoxScheduleAvailabilityContent"/> instance for mocking. </returns>
        public static DataBoxScheduleAvailabilityContent DataBoxScheduleAvailabilityContent(AzureLocation storageLocation = default, string country = null)
        {
            return new DataBoxScheduleAvailabilityContent(storageLocation, DataBoxSkuName.DataBox, country, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataTransferDetailsValidationContent"/>. </summary>
        /// <param name="dataExportDetails"> List of DataTransfer details to be used to export data from azure. </param>
        /// <param name="dataImportDetails"> List of DataTransfer details to be used to import data to azure. </param>
        /// <param name="deviceType"> Device type. </param>
        /// <param name="transferType"> Type of the transfer. </param>
        /// <returns> A new <see cref="Models.DataTransferDetailsValidationContent"/> instance for mocking. </returns>
        public static DataTransferDetailsValidationContent DataTransferDetailsValidationContent(IEnumerable<DataExportDetails> dataExportDetails = null, IEnumerable<DataImportDetails> dataImportDetails = null, DataBoxSkuName deviceType = default, DataBoxJobTransferType transferType = default)
        {
            dataExportDetails ??= new List<DataExportDetails>();
            dataImportDetails ??= new List<DataImportDetails>();

            return new DataTransferDetailsValidationContent(
                DataBoxValidationInputDiscriminator.ValidateDataTransferDetails,
                serializedAdditionalRawData: null,
                dataExportDetails?.ToList(),
                dataImportDetails?.ToList(),
                deviceType,
                transferType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataTransferDetailsValidationResult"/>. </summary>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="status"> Data transfer details validation status. </param>
        /// <returns> A new <see cref="Models.DataTransferDetailsValidationResult"/> instance for mocking. </returns>
        public static DataTransferDetailsValidationResult DataTransferDetailsValidationResult(ResponseError error = null, DataBoxValidationStatus? status = null)
        {
            return new DataTransferDetailsValidationResult(DataBoxValidationInputDiscriminator.ValidateDataTransferDetails, error, serializedAdditionalRawData: null, status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DiskScheduleAvailabilityContent"/>. </summary>
        /// <param name="storageLocation"> Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01. </param>
        /// <param name="country"> Country in which storage location should be supported. </param>
        /// <param name="expectedDataSizeInTerabytes"> The expected size of the data, which needs to be transferred in this job, in terabytes. </param>
        /// <returns> A new <see cref="Models.DiskScheduleAvailabilityContent"/> instance for mocking. </returns>
        public static DiskScheduleAvailabilityContent DiskScheduleAvailabilityContent(AzureLocation storageLocation = default, string country = null, int expectedDataSizeInTerabytes = default)
        {
            return new DiskScheduleAvailabilityContent(storageLocation, DataBoxSkuName.DataBoxDisk, country, serializedAdditionalRawData: null, expectedDataSizeInTerabytes);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HeavyScheduleAvailabilityContent"/>. </summary>
        /// <param name="storageLocation"> Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01. </param>
        /// <param name="country"> Country in which storage location should be supported. </param>
        /// <returns> A new <see cref="Models.HeavyScheduleAvailabilityContent"/> instance for mocking. </returns>
        public static HeavyScheduleAvailabilityContent HeavyScheduleAvailabilityContent(AzureLocation storageLocation = default, string country = null)
        {
            return new HeavyScheduleAvailabilityContent(storageLocation, DataBoxSkuName.DataBoxHeavy, country, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PreferencesValidationContent"/>. </summary>
        /// <param name="preference"> Preference of transport and data center. </param>
        /// <param name="deviceType"> Device type to be used for the job. </param>
        /// <returns> A new <see cref="Models.PreferencesValidationContent"/> instance for mocking. </returns>
        public static PreferencesValidationContent PreferencesValidationContent(DataBoxOrderPreferences preference = null, DataBoxSkuName deviceType = default)
        {
            return new PreferencesValidationContent(DataBoxValidationInputDiscriminator.ValidatePreferences, serializedAdditionalRawData: null, preference, deviceType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PreferencesValidationResult"/>. </summary>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="status"> Validation status of requested data center and transport. </param>
        /// <returns> A new <see cref="Models.PreferencesValidationResult"/> instance for mocking. </returns>
        public static PreferencesValidationResult PreferencesValidationResult(ResponseError error = null, DataBoxValidationStatus? status = null)
        {
            return new PreferencesValidationResult(DataBoxValidationInputDiscriminator.ValidatePreferences, error, serializedAdditionalRawData: null, status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SkuAvailabilityValidationContent"/>. </summary>
        /// <param name="deviceType"> Device type to be used for the job. </param>
        /// <param name="transferType"> Type of the transfer. </param>
        /// <param name="country"> ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. </param>
        /// <param name="location"> Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01. </param>
        /// <returns> A new <see cref="Models.SkuAvailabilityValidationContent"/> instance for mocking. </returns>
        public static SkuAvailabilityValidationContent SkuAvailabilityValidationContent(DataBoxSkuName deviceType = default, DataBoxJobTransferType transferType = default, string country = null, AzureLocation location = default)
        {
            return new SkuAvailabilityValidationContent(
                DataBoxValidationInputDiscriminator.ValidateSkuAvailability,
                serializedAdditionalRawData: null,
                deviceType,
                transferType,
                country,
                location);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SkuAvailabilityValidationResult"/>. </summary>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="status"> Sku availability validation status. </param>
        /// <returns> A new <see cref="Models.SkuAvailabilityValidationResult"/> instance for mocking. </returns>
        public static SkuAvailabilityValidationResult SkuAvailabilityValidationResult(ResponseError error = null, DataBoxValidationStatus? status = null)
        {
            return new SkuAvailabilityValidationResult(DataBoxValidationInputDiscriminator.ValidateSkuAvailability, error, serializedAdditionalRawData: null, status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SubscriptionIsAllowedToCreateJobValidationResult"/>. </summary>
        /// <param name="error"> Error code and message of validation response. </param>
        /// <param name="status"> Validation status of subscription permission to create job. </param>
        /// <returns> A new <see cref="Models.SubscriptionIsAllowedToCreateJobValidationResult"/> instance for mocking. </returns>
        public static SubscriptionIsAllowedToCreateJobValidationResult SubscriptionIsAllowedToCreateJobValidationResult(ResponseError error = null, DataBoxValidationStatus? status = null)
        {
            return new SubscriptionIsAllowedToCreateJobValidationResult(DataBoxValidationInputDiscriminator.ValidateSubscriptionIsAllowedToCreateJob, error, serializedAdditionalRawData: null, status);
        }
    }
}
