// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DataBox.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.DataBox.Samples
{
    public partial class Sample_DataBoxJobResource
    {
        // JobsList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDataBoxJobs_JobsList()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/JobsList.json
            // this example is just showing the usage of "Jobs_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "YourSubscriptionId";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (DataBoxJobResource item in subscriptionResource.GetDataBoxJobsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataBoxJobData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // MarkDevicesShipped
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MarkDevicesShipped_MarkDevicesShipped()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/MarkDevicesShipped.json
            // this example is just showing the usage of "Jobs_MarkDevicesShipped" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxJobResource created on azure
            // for more information of creating DataBoxJobResource, please refer to the document of DataBoxJobResource
            string subscriptionId = "YourSubscriptionId";
            string resourceGroupName = "YourResourceGroupName";
            string jobName = "TestJobName1";
            ResourceIdentifier dataBoxJobResourceId = DataBoxJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            DataBoxJobResource dataBoxJob = client.GetDataBoxJobResource(dataBoxJobResourceId);

            // invoke the operation
            MarkDevicesShippedContent content = new MarkDevicesShippedContent(new PackageCarrierInfo()
            {
                CarrierName = "testCarrier",
                TrackingId = "000000",
            });
            await dataBoxJob.MarkDevicesShippedAsync(content);

            Console.WriteLine($"Succeeded");
        }

        // JobsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_JobsGet()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/JobsGet.json
            // this example is just showing the usage of "Jobs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxJobResource created on azure
            // for more information of creating DataBoxJobResource, please refer to the document of DataBoxJobResource
            string subscriptionId = "YourSubscriptionId";
            string resourceGroupName = "YourResourceGroupName";
            string jobName = "TestJobName1";
            ResourceIdentifier dataBoxJobResourceId = DataBoxJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            DataBoxJobResource dataBoxJob = client.GetDataBoxJobResource(dataBoxJobResourceId);

            // invoke the operation
            string expand = "details";
            DataBoxJobResource result = await dataBoxJob.GetAsync(expand: expand);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataBoxJobData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // JobsGetCmk
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_JobsGetCmk()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/JobsGetCmk.json
            // this example is just showing the usage of "Jobs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxJobResource created on azure
            // for more information of creating DataBoxJobResource, please refer to the document of DataBoxJobResource
            string subscriptionId = "YourSubscriptionId";
            string resourceGroupName = "YourResourceGroupName";
            string jobName = "TestJobName1";
            ResourceIdentifier dataBoxJobResourceId = DataBoxJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            DataBoxJobResource dataBoxJob = client.GetDataBoxJobResource(dataBoxJobResourceId);

            // invoke the operation
            string expand = "details";
            DataBoxJobResource result = await dataBoxJob.GetAsync(expand: expand);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataBoxJobData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // JobsGetCopyStuck
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_JobsGetCopyStuck()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/JobsGetCopyStuck.json
            // this example is just showing the usage of "Jobs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxJobResource created on azure
            // for more information of creating DataBoxJobResource, please refer to the document of DataBoxJobResource
            string subscriptionId = "YourSubscriptionId";
            string resourceGroupName = "YourResourceGroupName";
            string jobName = "TestJobName1";
            ResourceIdentifier dataBoxJobResourceId = DataBoxJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            DataBoxJobResource dataBoxJob = client.GetDataBoxJobResource(dataBoxJobResourceId);

            // invoke the operation
            string expand = "details";
            DataBoxJobResource result = await dataBoxJob.GetAsync(expand: expand);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataBoxJobData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // JobsGetExport
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_JobsGetExport()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/JobsGetExport.json
            // this example is just showing the usage of "Jobs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxJobResource created on azure
            // for more information of creating DataBoxJobResource, please refer to the document of DataBoxJobResource
            string subscriptionId = "YourSubscriptionId";
            string resourceGroupName = "YourResourceGroupName";
            string jobName = "TestJobName1";
            ResourceIdentifier dataBoxJobResourceId = DataBoxJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            DataBoxJobResource dataBoxJob = client.GetDataBoxJobResource(dataBoxJobResourceId);

            // invoke the operation
            string expand = "details";
            DataBoxJobResource result = await dataBoxJob.GetAsync(expand: expand);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataBoxJobData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // JobsGetWaitingForAction
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_JobsGetWaitingForAction()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/JobsGetWaitingForAction.json
            // this example is just showing the usage of "Jobs_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxJobResource created on azure
            // for more information of creating DataBoxJobResource, please refer to the document of DataBoxJobResource
            string subscriptionId = "YourSubscriptionId";
            string resourceGroupName = "YourResourceGroupName";
            string jobName = "TestJobName1";
            ResourceIdentifier dataBoxJobResourceId = DataBoxJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            DataBoxJobResource dataBoxJob = client.GetDataBoxJobResource(dataBoxJobResourceId);

            // invoke the operation
            string expand = "details";
            DataBoxJobResource result = await dataBoxJob.GetAsync(expand: expand);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataBoxJobData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // JobsDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_JobsDelete()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/JobsDelete.json
            // this example is just showing the usage of "Jobs_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxJobResource created on azure
            // for more information of creating DataBoxJobResource, please refer to the document of DataBoxJobResource
            string subscriptionId = "YourSubscriptionId";
            string resourceGroupName = "YourResourceGroupName";
            string jobName = "TestJobName1";
            ResourceIdentifier dataBoxJobResourceId = DataBoxJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            DataBoxJobResource dataBoxJob = client.GetDataBoxJobResource(dataBoxJobResourceId);

            // invoke the operation
            await dataBoxJob.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // BookShipmentPickupPost
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task BookShipmentPickUp_BookShipmentPickupPost()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/BookShipmentPickupPost.json
            // this example is just showing the usage of "Jobs_BookShipmentPickUp" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxJobResource created on azure
            // for more information of creating DataBoxJobResource, please refer to the document of DataBoxJobResource
            string subscriptionId = "YourSubscriptionId";
            string resourceGroupName = "YourResourceGroupName";
            string jobName = "TestJobName1";
            ResourceIdentifier dataBoxJobResourceId = DataBoxJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            DataBoxJobResource dataBoxJob = client.GetDataBoxJobResource(dataBoxJobResourceId);

            // invoke the operation
            ShipmentPickUpContent content = new ShipmentPickUpContent(DateTimeOffset.Parse("2019-09-20T18:30:00Z"), DateTimeOffset.Parse("2019-09-22T18:30:00Z"), "Front desk");
            DataBoxShipmentPickUpResult result = await dataBoxJob.BookShipmentPickUpAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // JobsCancelPost
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Cancel_JobsCancelPost()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/JobsCancelPost.json
            // this example is just showing the usage of "Jobs_Cancel" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxJobResource created on azure
            // for more information of creating DataBoxJobResource, please refer to the document of DataBoxJobResource
            string subscriptionId = "YourSubscriptionId";
            string resourceGroupName = "YourResourceGroupName";
            string jobName = "TestJobName1";
            ResourceIdentifier dataBoxJobResourceId = DataBoxJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            DataBoxJobResource dataBoxJob = client.GetDataBoxJobResource(dataBoxJobResourceId);

            // invoke the operation
            DataBoxJobCancellationReason cancellationReason = new DataBoxJobCancellationReason("CancelTest");
            await dataBoxJob.CancelAsync(cancellationReason);

            Console.WriteLine($"Succeeded");
        }

        // JobsListCredentials
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetCredentials_JobsListCredentials()
        {
            // Generated from example definition: specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/JobsListCredentials.json
            // this example is just showing the usage of "Jobs_ListCredentials" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataBoxJobResource created on azure
            // for more information of creating DataBoxJobResource, please refer to the document of DataBoxJobResource
            string subscriptionId = "YourSubscriptionId";
            string resourceGroupName = "YourResourceGroupName";
            string jobName = "TestJobName1";
            ResourceIdentifier dataBoxJobResourceId = DataBoxJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName);
            DataBoxJobResource dataBoxJob = client.GetDataBoxJobResource(dataBoxJobResourceId);

            // invoke the operation and iterate over the result
            await foreach (UnencryptedCredentials item in dataBoxJob.GetCredentialsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
