// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights
{
    /// <summary>
    /// A class representing the ViewResourceFormat data model.
    /// The view resource format.
    /// </summary>
    public partial class ViewResourceFormatData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ViewResourceFormatData"/>. </summary>
        public ViewResourceFormatData()
        {
            DisplayName = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="ViewResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="viewName"> Name of the view. </param>
        /// <param name="userId"> the user ID. </param>
        /// <param name="tenantId"> the hub name. </param>
        /// <param name="displayName"> Localized display name for the view. </param>
        /// <param name="definition"> View definition. </param>
        /// <param name="changed"> Date time when view was last modified. </param>
        /// <param name="created"> Date time when view was created. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ViewResourceFormatData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string viewName, string userId, Guid? tenantId, IDictionary<string, string> displayName, string definition, DateTimeOffset? changed, DateTimeOffset? created, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ViewName = viewName;
            UserId = userId;
            TenantId = tenantId;
            DisplayName = displayName;
            Definition = definition;
            Changed = changed;
            Created = created;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the view. </summary>
        public string ViewName { get; }
        /// <summary> the user ID. </summary>
        public string UserId { get; set; }
        /// <summary> the hub name. </summary>
        public Guid? TenantId { get; }
        /// <summary> Localized display name for the view. </summary>
        public IDictionary<string, string> DisplayName { get; }
        /// <summary> View definition. </summary>
        public string Definition { get; set; }
        /// <summary> Date time when view was last modified. </summary>
        public DateTimeOffset? Changed { get; }
        /// <summary> Date time when view was created. </summary>
        public DateTimeOffset? Created { get; }
    }
}
