// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.CustomerInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights
{
    public partial class RoleAssignmentResourceFormatData : IUtf8JsonSerializable, IJsonModel<RoleAssignmentResourceFormatData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RoleAssignmentResourceFormatData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RoleAssignmentResourceFormatData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoleAssignmentResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RoleAssignmentResourceFormatData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(TenantId))
            {
                writer.WritePropertyName("tenantId"u8);
                writer.WriteStringValue(TenantId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AssignmentName))
            {
                writer.WritePropertyName("assignmentName"u8);
                writer.WriteStringValue(AssignmentName);
            }
            if (Optional.IsCollectionDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStartObject();
                foreach (var item in DisplayName)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStartObject();
                foreach (var item in Description)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(Role))
            {
                writer.WritePropertyName("role"u8);
                writer.WriteStringValue(Role.Value.ToSerialString());
            }
            if (Optional.IsCollectionDefined(Principals))
            {
                writer.WritePropertyName("principals"u8);
                writer.WriteStartArray();
                foreach (var item in Principals)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Profiles))
            {
                writer.WritePropertyName("profiles"u8);
                writer.WriteObjectValue(Profiles, options);
            }
            if (Optional.IsDefined(Interactions))
            {
                writer.WritePropertyName("interactions"u8);
                writer.WriteObjectValue(Interactions, options);
            }
            if (Optional.IsDefined(Links))
            {
                writer.WritePropertyName("links"u8);
                writer.WriteObjectValue(Links, options);
            }
            if (Optional.IsDefined(Kpis))
            {
                writer.WritePropertyName("kpis"u8);
                writer.WriteObjectValue(Kpis, options);
            }
            if (Optional.IsDefined(SasPolicies))
            {
                writer.WritePropertyName("sasPolicies"u8);
                writer.WriteObjectValue(SasPolicies, options);
            }
            if (Optional.IsDefined(Connectors))
            {
                writer.WritePropertyName("connectors"u8);
                writer.WriteObjectValue(Connectors, options);
            }
            if (Optional.IsDefined(Views))
            {
                writer.WritePropertyName("views"u8);
                writer.WriteObjectValue(Views, options);
            }
            if (Optional.IsDefined(RelationshipLinks))
            {
                writer.WritePropertyName("relationshipLinks"u8);
                writer.WriteObjectValue(RelationshipLinks, options);
            }
            if (Optional.IsDefined(Relationships))
            {
                writer.WritePropertyName("relationships"u8);
                writer.WriteObjectValue(Relationships, options);
            }
            if (Optional.IsDefined(WidgetTypes))
            {
                writer.WritePropertyName("widgetTypes"u8);
                writer.WriteObjectValue(WidgetTypes, options);
            }
            if (Optional.IsDefined(RoleAssignments))
            {
                writer.WritePropertyName("roleAssignments"u8);
                writer.WriteObjectValue(RoleAssignments, options);
            }
            if (Optional.IsDefined(ConflationPolicies))
            {
                writer.WritePropertyName("conflationPolicies"u8);
                writer.WriteObjectValue(ConflationPolicies, options);
            }
            if (Optional.IsDefined(Segments))
            {
                writer.WritePropertyName("segments"u8);
                writer.WriteObjectValue(Segments, options);
            }
            writer.WriteEndObject();
        }

        RoleAssignmentResourceFormatData IJsonModel<RoleAssignmentResourceFormatData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoleAssignmentResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RoleAssignmentResourceFormatData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRoleAssignmentResourceFormatData(document.RootElement, options);
        }

        internal static RoleAssignmentResourceFormatData DeserializeRoleAssignmentResourceFormatData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            Guid? tenantId = default;
            string assignmentName = default;
            IDictionary<string, string> displayName = default;
            IDictionary<string, string> description = default;
            ProvisioningState? provisioningState = default;
            RoleType? role = default;
            IList<AssignmentPrincipal> principals = default;
            ResourceSetDescription profiles = default;
            ResourceSetDescription interactions = default;
            ResourceSetDescription links = default;
            ResourceSetDescription kpis = default;
            ResourceSetDescription sasPolicies = default;
            ResourceSetDescription connectors = default;
            ResourceSetDescription views = default;
            ResourceSetDescription relationshipLinks = default;
            ResourceSetDescription relationships = default;
            ResourceSetDescription widgetTypes = default;
            ResourceSetDescription roleAssignments = default;
            ResourceSetDescription conflationPolicies = default;
            ResourceSetDescription segments = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("tenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            tenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("assignmentName"u8))
                        {
                            assignmentName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("displayName"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            displayName = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("description"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            description = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new ProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("role"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            role = property0.Value.GetString().ToRoleType();
                            continue;
                        }
                        if (property0.NameEquals("principals"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<AssignmentPrincipal> array = new List<AssignmentPrincipal>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(AssignmentPrincipal.DeserializeAssignmentPrincipal(item, options));
                            }
                            principals = array;
                            continue;
                        }
                        if (property0.NameEquals("profiles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            profiles = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("interactions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            interactions = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("links"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            links = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("kpis"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            kpis = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("sasPolicies"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sasPolicies = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("connectors"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            connectors = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("views"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            views = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("relationshipLinks"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            relationshipLinks = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("relationships"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            relationships = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("widgetTypes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            widgetTypes = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("roleAssignments"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            roleAssignments = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("conflationPolicies"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            conflationPolicies = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("segments"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            segments = ResourceSetDescription.DeserializeResourceSetDescription(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RoleAssignmentResourceFormatData(
                id,
                name,
                type,
                systemData,
                tenantId,
                assignmentName,
                displayName ?? new ChangeTrackingDictionary<string, string>(),
                description ?? new ChangeTrackingDictionary<string, string>(),
                provisioningState,
                role,
                principals ?? new ChangeTrackingList<AssignmentPrincipal>(),
                profiles,
                interactions,
                links,
                kpis,
                sasPolicies,
                connectors,
                views,
                relationshipLinks,
                relationships,
                widgetTypes,
                roleAssignments,
                conflationPolicies,
                segments,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RoleAssignmentResourceFormatData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoleAssignmentResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RoleAssignmentResourceFormatData)} does not support writing '{options.Format}' format.");
            }
        }

        RoleAssignmentResourceFormatData IPersistableModel<RoleAssignmentResourceFormatData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoleAssignmentResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRoleAssignmentResourceFormatData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RoleAssignmentResourceFormatData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RoleAssignmentResourceFormatData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
