// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.CustomerInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights
{
    /// <summary>
    /// A class representing the RelationshipResourceFormat data model.
    /// The relationship resource format.
    /// </summary>
    public partial class RelationshipResourceFormatData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RelationshipResourceFormatData"/>. </summary>
        public RelationshipResourceFormatData()
        {
            DisplayName = new ChangeTrackingDictionary<string, string>();
            Description = new ChangeTrackingDictionary<string, string>();
            Fields = new ChangeTrackingList<PropertyDefinition>();
            LookupMappings = new ChangeTrackingList<RelationshipTypeMapping>();
        }

        /// <summary> Initializes a new instance of <see cref="RelationshipResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="cardinality"> The Relationship Cardinality. </param>
        /// <param name="displayName"> Localized display name for the Relationship. </param>
        /// <param name="description"> Localized descriptions for the Relationship. </param>
        /// <param name="expiryDateTimeUtc"> The expiry date time in UTC. </param>
        /// <param name="fields"> The properties of the Relationship. </param>
        /// <param name="lookupMappings"> Optional property to be used to map fields in profile to their strong ids in related profile. </param>
        /// <param name="profileType"> Profile type. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="relationshipName"> The Relationship name. </param>
        /// <param name="relatedProfileType"> Related profile being referenced. </param>
        /// <param name="relationshipGuidId"> The relationship guid id. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RelationshipResourceFormatData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, CardinalityType? cardinality, IDictionary<string, string> displayName, IDictionary<string, string> description, DateTimeOffset? expiryDateTimeUtc, IList<PropertyDefinition> fields, IList<RelationshipTypeMapping> lookupMappings, string profileType, ProvisioningState? provisioningState, string relationshipName, string relatedProfileType, string relationshipGuidId, Guid? tenantId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Cardinality = cardinality;
            DisplayName = displayName;
            Description = description;
            ExpiryDateTimeUtc = expiryDateTimeUtc;
            Fields = fields;
            LookupMappings = lookupMappings;
            ProfileType = profileType;
            ProvisioningState = provisioningState;
            RelationshipName = relationshipName;
            RelatedProfileType = relatedProfileType;
            RelationshipGuidId = relationshipGuidId;
            TenantId = tenantId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Relationship Cardinality. </summary>
        public CardinalityType? Cardinality { get; set; }
        /// <summary> Localized display name for the Relationship. </summary>
        public IDictionary<string, string> DisplayName { get; }
        /// <summary> Localized descriptions for the Relationship. </summary>
        public IDictionary<string, string> Description { get; }
        /// <summary> The expiry date time in UTC. </summary>
        public DateTimeOffset? ExpiryDateTimeUtc { get; set; }
        /// <summary> The properties of the Relationship. </summary>
        public IList<PropertyDefinition> Fields { get; }
        /// <summary> Optional property to be used to map fields in profile to their strong ids in related profile. </summary>
        public IList<RelationshipTypeMapping> LookupMappings { get; }
        /// <summary> Profile type. </summary>
        public string ProfileType { get; set; }
        /// <summary> Provisioning state. </summary>
        public ProvisioningState? ProvisioningState { get; }
        /// <summary> The Relationship name. </summary>
        public string RelationshipName { get; }
        /// <summary> Related profile being referenced. </summary>
        public string RelatedProfileType { get; set; }
        /// <summary> The relationship guid id. </summary>
        public string RelationshipGuidId { get; }
        /// <summary> The hub name. </summary>
        public Guid? TenantId { get; }
    }
}
