// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.CustomerInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="RelationshipResourceFormatResource"/> and their operations.
    /// Each <see cref="RelationshipResourceFormatResource"/> in the collection will belong to the same instance of <see cref="HubResource"/>.
    /// To get a <see cref="RelationshipResourceFormatCollection"/> instance call the GetRelationshipResourceFormats method from an instance of <see cref="HubResource"/>.
    /// </summary>
    public partial class RelationshipResourceFormatCollection : ArmCollection, IEnumerable<RelationshipResourceFormatResource>, IAsyncEnumerable<RelationshipResourceFormatResource>
    {
        private readonly ClientDiagnostics _relationshipResourceFormatRelationshipsClientDiagnostics;
        private readonly RelationshipsRestOperations _relationshipResourceFormatRelationshipsRestClient;

        /// <summary> Initializes a new instance of the <see cref="RelationshipResourceFormatCollection"/> class for mocking. </summary>
        protected RelationshipResourceFormatCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="RelationshipResourceFormatCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal RelationshipResourceFormatCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _relationshipResourceFormatRelationshipsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.CustomerInsights", RelationshipResourceFormatResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(RelationshipResourceFormatResource.ResourceType, out string relationshipResourceFormatRelationshipsApiVersion);
            _relationshipResourceFormatRelationshipsRestClient = new RelationshipsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, relationshipResourceFormatRelationshipsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != HubResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, HubResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates a relationship or updates an existing relationship within a hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="relationshipName"> The name of the Relationship. </param>
        /// <param name="data"> Parameters supplied to the CreateOrUpdate Relationship operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<RelationshipResourceFormatResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string relationshipName, RelationshipResourceFormatData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipName, nameof(relationshipName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _relationshipResourceFormatRelationshipsClientDiagnostics.CreateScope("RelationshipResourceFormatCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _relationshipResourceFormatRelationshipsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipName, data, cancellationToken).ConfigureAwait(false);
                var operation = new CustomerInsightsArmOperation<RelationshipResourceFormatResource>(new RelationshipResourceFormatOperationSource(Client), _relationshipResourceFormatRelationshipsClientDiagnostics, Pipeline, _relationshipResourceFormatRelationshipsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a relationship or updates an existing relationship within a hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="relationshipName"> The name of the Relationship. </param>
        /// <param name="data"> Parameters supplied to the CreateOrUpdate Relationship operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<RelationshipResourceFormatResource> CreateOrUpdate(WaitUntil waitUntil, string relationshipName, RelationshipResourceFormatData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipName, nameof(relationshipName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _relationshipResourceFormatRelationshipsClientDiagnostics.CreateScope("RelationshipResourceFormatCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _relationshipResourceFormatRelationshipsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipName, data, cancellationToken);
                var operation = new CustomerInsightsArmOperation<RelationshipResourceFormatResource>(new RelationshipResourceFormatOperationSource(Client), _relationshipResourceFormatRelationshipsClientDiagnostics, Pipeline, _relationshipResourceFormatRelationshipsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified relationship.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipName"> The name of the relationship. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipName"/> is null. </exception>
        public virtual async Task<Response<RelationshipResourceFormatResource>> GetAsync(string relationshipName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipName, nameof(relationshipName));

            using var scope = _relationshipResourceFormatRelationshipsClientDiagnostics.CreateScope("RelationshipResourceFormatCollection.Get");
            scope.Start();
            try
            {
                var response = await _relationshipResourceFormatRelationshipsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new RelationshipResourceFormatResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified relationship.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipName"> The name of the relationship. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipName"/> is null. </exception>
        public virtual Response<RelationshipResourceFormatResource> Get(string relationshipName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipName, nameof(relationshipName));

            using var scope = _relationshipResourceFormatRelationshipsClientDiagnostics.CreateScope("RelationshipResourceFormatCollection.Get");
            scope.Start();
            try
            {
                var response = _relationshipResourceFormatRelationshipsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new RelationshipResourceFormatResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all relationships in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_ListByHub</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="RelationshipResourceFormatResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<RelationshipResourceFormatResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _relationshipResourceFormatRelationshipsRestClient.CreateListByHubRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _relationshipResourceFormatRelationshipsRestClient.CreateListByHubNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new RelationshipResourceFormatResource(Client, RelationshipResourceFormatData.DeserializeRelationshipResourceFormatData(e)), _relationshipResourceFormatRelationshipsClientDiagnostics, Pipeline, "RelationshipResourceFormatCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all relationships in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_ListByHub</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="RelationshipResourceFormatResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<RelationshipResourceFormatResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _relationshipResourceFormatRelationshipsRestClient.CreateListByHubRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _relationshipResourceFormatRelationshipsRestClient.CreateListByHubNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new RelationshipResourceFormatResource(Client, RelationshipResourceFormatData.DeserializeRelationshipResourceFormatData(e)), _relationshipResourceFormatRelationshipsClientDiagnostics, Pipeline, "RelationshipResourceFormatCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipName"> The name of the relationship. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string relationshipName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipName, nameof(relationshipName));

            using var scope = _relationshipResourceFormatRelationshipsClientDiagnostics.CreateScope("RelationshipResourceFormatCollection.Exists");
            scope.Start();
            try
            {
                var response = await _relationshipResourceFormatRelationshipsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipName"> The name of the relationship. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipName"/> is null. </exception>
        public virtual Response<bool> Exists(string relationshipName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipName, nameof(relationshipName));

            using var scope = _relationshipResourceFormatRelationshipsClientDiagnostics.CreateScope("RelationshipResourceFormatCollection.Exists");
            scope.Start();
            try
            {
                var response = _relationshipResourceFormatRelationshipsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipName"> The name of the relationship. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipName"/> is null. </exception>
        public virtual async Task<NullableResponse<RelationshipResourceFormatResource>> GetIfExistsAsync(string relationshipName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipName, nameof(relationshipName));

            using var scope = _relationshipResourceFormatRelationshipsClientDiagnostics.CreateScope("RelationshipResourceFormatCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _relationshipResourceFormatRelationshipsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<RelationshipResourceFormatResource>(response.GetRawResponse());
                return Response.FromValue(new RelationshipResourceFormatResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Relationships_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipName"> The name of the relationship. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipName"/> is null. </exception>
        public virtual NullableResponse<RelationshipResourceFormatResource> GetIfExists(string relationshipName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipName, nameof(relationshipName));

            using var scope = _relationshipResourceFormatRelationshipsClientDiagnostics.CreateScope("RelationshipResourceFormatCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _relationshipResourceFormatRelationshipsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<RelationshipResourceFormatResource>(response.GetRawResponse());
                return Response.FromValue(new RelationshipResourceFormatResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<RelationshipResourceFormatResource> IEnumerable<RelationshipResourceFormatResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<RelationshipResourceFormatResource> IAsyncEnumerable<RelationshipResourceFormatResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
