// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.CustomerInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="RelationshipLinkResourceFormatResource"/> and their operations.
    /// Each <see cref="RelationshipLinkResourceFormatResource"/> in the collection will belong to the same instance of <see cref="HubResource"/>.
    /// To get a <see cref="RelationshipLinkResourceFormatCollection"/> instance call the GetRelationshipLinkResourceFormats method from an instance of <see cref="HubResource"/>.
    /// </summary>
    public partial class RelationshipLinkResourceFormatCollection : ArmCollection, IEnumerable<RelationshipLinkResourceFormatResource>, IAsyncEnumerable<RelationshipLinkResourceFormatResource>
    {
        private readonly ClientDiagnostics _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics;
        private readonly RelationshipLinksRestOperations _relationshipLinkResourceFormatRelationshipLinksRestClient;

        /// <summary> Initializes a new instance of the <see cref="RelationshipLinkResourceFormatCollection"/> class for mocking. </summary>
        protected RelationshipLinkResourceFormatCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="RelationshipLinkResourceFormatCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal RelationshipLinkResourceFormatCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.CustomerInsights", RelationshipLinkResourceFormatResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(RelationshipLinkResourceFormatResource.ResourceType, out string relationshipLinkResourceFormatRelationshipLinksApiVersion);
            _relationshipLinkResourceFormatRelationshipLinksRestClient = new RelationshipLinksRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, relationshipLinkResourceFormatRelationshipLinksApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != HubResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, HubResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates a relationship link or updates an existing relationship link within a hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="relationshipLinkName"> The name of the relationship link. </param>
        /// <param name="data"> Parameters supplied to the CreateOrUpdate relationship link operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipLinkName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<RelationshipLinkResourceFormatResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string relationshipLinkName, RelationshipLinkResourceFormatData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipLinkName, nameof(relationshipLinkName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics.CreateScope("RelationshipLinkResourceFormatCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _relationshipLinkResourceFormatRelationshipLinksRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipLinkName, data, cancellationToken).ConfigureAwait(false);
                var operation = new CustomerInsightsArmOperation<RelationshipLinkResourceFormatResource>(new RelationshipLinkResourceFormatOperationSource(Client), _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics, Pipeline, _relationshipLinkResourceFormatRelationshipLinksRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipLinkName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a relationship link or updates an existing relationship link within a hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="relationshipLinkName"> The name of the relationship link. </param>
        /// <param name="data"> Parameters supplied to the CreateOrUpdate relationship link operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipLinkName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<RelationshipLinkResourceFormatResource> CreateOrUpdate(WaitUntil waitUntil, string relationshipLinkName, RelationshipLinkResourceFormatData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipLinkName, nameof(relationshipLinkName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics.CreateScope("RelationshipLinkResourceFormatCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _relationshipLinkResourceFormatRelationshipLinksRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipLinkName, data, cancellationToken);
                var operation = new CustomerInsightsArmOperation<RelationshipLinkResourceFormatResource>(new RelationshipLinkResourceFormatOperationSource(Client), _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics, Pipeline, _relationshipLinkResourceFormatRelationshipLinksRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipLinkName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified relationship Link.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipLinkName"> The name of the relationship link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipLinkName"/> is null. </exception>
        public virtual async Task<Response<RelationshipLinkResourceFormatResource>> GetAsync(string relationshipLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipLinkName, nameof(relationshipLinkName));

            using var scope = _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics.CreateScope("RelationshipLinkResourceFormatCollection.Get");
            scope.Start();
            try
            {
                var response = await _relationshipLinkResourceFormatRelationshipLinksRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipLinkName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new RelationshipLinkResourceFormatResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets information about the specified relationship Link.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipLinkName"> The name of the relationship link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipLinkName"/> is null. </exception>
        public virtual Response<RelationshipLinkResourceFormatResource> Get(string relationshipLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipLinkName, nameof(relationshipLinkName));

            using var scope = _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics.CreateScope("RelationshipLinkResourceFormatCollection.Get");
            scope.Start();
            try
            {
                var response = _relationshipLinkResourceFormatRelationshipLinksRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipLinkName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new RelationshipLinkResourceFormatResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all relationship links in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_ListByHub</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="RelationshipLinkResourceFormatResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<RelationshipLinkResourceFormatResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _relationshipLinkResourceFormatRelationshipLinksRestClient.CreateListByHubRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _relationshipLinkResourceFormatRelationshipLinksRestClient.CreateListByHubNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new RelationshipLinkResourceFormatResource(Client, RelationshipLinkResourceFormatData.DeserializeRelationshipLinkResourceFormatData(e)), _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics, Pipeline, "RelationshipLinkResourceFormatCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all relationship links in the hub.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_ListByHub</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="RelationshipLinkResourceFormatResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<RelationshipLinkResourceFormatResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _relationshipLinkResourceFormatRelationshipLinksRestClient.CreateListByHubRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _relationshipLinkResourceFormatRelationshipLinksRestClient.CreateListByHubNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new RelationshipLinkResourceFormatResource(Client, RelationshipLinkResourceFormatData.DeserializeRelationshipLinkResourceFormatData(e)), _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics, Pipeline, "RelationshipLinkResourceFormatCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipLinkName"> The name of the relationship link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipLinkName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string relationshipLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipLinkName, nameof(relationshipLinkName));

            using var scope = _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics.CreateScope("RelationshipLinkResourceFormatCollection.Exists");
            scope.Start();
            try
            {
                var response = await _relationshipLinkResourceFormatRelationshipLinksRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipLinkName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipLinkName"> The name of the relationship link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipLinkName"/> is null. </exception>
        public virtual Response<bool> Exists(string relationshipLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipLinkName, nameof(relationshipLinkName));

            using var scope = _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics.CreateScope("RelationshipLinkResourceFormatCollection.Exists");
            scope.Start();
            try
            {
                var response = _relationshipLinkResourceFormatRelationshipLinksRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipLinkName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipLinkName"> The name of the relationship link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipLinkName"/> is null. </exception>
        public virtual async Task<NullableResponse<RelationshipLinkResourceFormatResource>> GetIfExistsAsync(string relationshipLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipLinkName, nameof(relationshipLinkName));

            using var scope = _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics.CreateScope("RelationshipLinkResourceFormatCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _relationshipLinkResourceFormatRelationshipLinksRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipLinkName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<RelationshipLinkResourceFormatResource>(response.GetRawResponse());
                return Response.FromValue(new RelationshipLinkResourceFormatResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RelationshipLinks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-04-26</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RelationshipLinkResourceFormatResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationshipLinkName"> The name of the relationship link. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="relationshipLinkName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="relationshipLinkName"/> is null. </exception>
        public virtual NullableResponse<RelationshipLinkResourceFormatResource> GetIfExists(string relationshipLinkName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(relationshipLinkName, nameof(relationshipLinkName));

            using var scope = _relationshipLinkResourceFormatRelationshipLinksClientDiagnostics.CreateScope("RelationshipLinkResourceFormatCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _relationshipLinkResourceFormatRelationshipLinksRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, relationshipLinkName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<RelationshipLinkResourceFormatResource>(response.GetRawResponse());
                return Response.FromValue(new RelationshipLinkResourceFormatResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<RelationshipLinkResourceFormatResource> IEnumerable<RelationshipLinkResourceFormatResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<RelationshipLinkResourceFormatResource> IAsyncEnumerable<RelationshipLinkResourceFormatResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
