// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.CustomerInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights
{
    /// <summary>
    /// A class representing the PredictionResourceFormat data model.
    /// The prediction resource format.
    /// </summary>
    public partial class PredictionResourceFormatData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PredictionResourceFormatData"/>. </summary>
        public PredictionResourceFormatData()
        {
            Description = new ChangeTrackingDictionary<string, string>();
            DisplayName = new ChangeTrackingDictionary<string, string>();
            InvolvedInteractionTypes = new ChangeTrackingList<string>();
            InvolvedKpiTypes = new ChangeTrackingList<string>();
            InvolvedRelationships = new ChangeTrackingList<string>();
            Grades = new ChangeTrackingList<PredictionGradesItem>();
        }

        /// <summary> Initializes a new instance of <see cref="PredictionResourceFormatData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description of the prediction. </param>
        /// <param name="displayName"> Display name of the prediction. </param>
        /// <param name="involvedInteractionTypes"> Interaction types involved in the prediction. </param>
        /// <param name="involvedKpiTypes"> KPI types involved in the prediction. </param>
        /// <param name="involvedRelationships"> Relationships involved in the prediction. </param>
        /// <param name="negativeOutcomeExpression"> Negative outcome expression. </param>
        /// <param name="positiveOutcomeExpression"> Positive outcome expression. </param>
        /// <param name="primaryProfileType"> Primary profile type. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="predictionName"> Name of the prediction. </param>
        /// <param name="scopeExpression"> Scope expression. </param>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="autoAnalyze"> Whether do auto analyze. </param>
        /// <param name="mappings"> Definition of the link mapping of prediction. </param>
        /// <param name="scoreLabel"> Score label. </param>
        /// <param name="grades"> The prediction grades. </param>
        /// <param name="systemGeneratedEntities"> System generated entities. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PredictionResourceFormatData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> description, IDictionary<string, string> displayName, IList<string> involvedInteractionTypes, IList<string> involvedKpiTypes, IList<string> involvedRelationships, string negativeOutcomeExpression, string positiveOutcomeExpression, string primaryProfileType, ProvisioningState? provisioningState, string predictionName, string scopeExpression, Guid? tenantId, bool? autoAnalyze, PredictionMappings mappings, string scoreLabel, IList<PredictionGradesItem> grades, PredictionSystemGeneratedEntities systemGeneratedEntities, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            DisplayName = displayName;
            InvolvedInteractionTypes = involvedInteractionTypes;
            InvolvedKpiTypes = involvedKpiTypes;
            InvolvedRelationships = involvedRelationships;
            NegativeOutcomeExpression = negativeOutcomeExpression;
            PositiveOutcomeExpression = positiveOutcomeExpression;
            PrimaryProfileType = primaryProfileType;
            ProvisioningState = provisioningState;
            PredictionName = predictionName;
            ScopeExpression = scopeExpression;
            TenantId = tenantId;
            AutoAnalyze = autoAnalyze;
            Mappings = mappings;
            ScoreLabel = scoreLabel;
            Grades = grades;
            SystemGeneratedEntities = systemGeneratedEntities;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Description of the prediction. </summary>
        public IDictionary<string, string> Description { get; }
        /// <summary> Display name of the prediction. </summary>
        public IDictionary<string, string> DisplayName { get; }
        /// <summary> Interaction types involved in the prediction. </summary>
        public IList<string> InvolvedInteractionTypes { get; }
        /// <summary> KPI types involved in the prediction. </summary>
        public IList<string> InvolvedKpiTypes { get; }
        /// <summary> Relationships involved in the prediction. </summary>
        public IList<string> InvolvedRelationships { get; }
        /// <summary> Negative outcome expression. </summary>
        public string NegativeOutcomeExpression { get; set; }
        /// <summary> Positive outcome expression. </summary>
        public string PositiveOutcomeExpression { get; set; }
        /// <summary> Primary profile type. </summary>
        public string PrimaryProfileType { get; set; }
        /// <summary> Provisioning state. </summary>
        public ProvisioningState? ProvisioningState { get; }
        /// <summary> Name of the prediction. </summary>
        public string PredictionName { get; set; }
        /// <summary> Scope expression. </summary>
        public string ScopeExpression { get; set; }
        /// <summary> The hub name. </summary>
        public Guid? TenantId { get; }
        /// <summary> Whether do auto analyze. </summary>
        public bool? AutoAnalyze { get; set; }
        /// <summary> Definition of the link mapping of prediction. </summary>
        public PredictionMappings Mappings { get; set; }
        /// <summary> Score label. </summary>
        public string ScoreLabel { get; set; }
        /// <summary> The prediction grades. </summary>
        public IList<PredictionGradesItem> Grades { get; }
        /// <summary> System generated entities. </summary>
        public PredictionSystemGeneratedEntities SystemGeneratedEntities { get; }
    }
}
