// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.CustomerInsights.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CustomerInsights
{
    public partial class PredictionResourceFormatData : IUtf8JsonSerializable, IJsonModel<PredictionResourceFormatData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PredictionResourceFormatData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PredictionResourceFormatData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PredictionResourceFormatData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStartObject();
                foreach (var item in Description)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStartObject();
                foreach (var item in DisplayName)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(InvolvedInteractionTypes))
            {
                writer.WritePropertyName("involvedInteractionTypes"u8);
                writer.WriteStartArray();
                foreach (var item in InvolvedInteractionTypes)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(InvolvedKpiTypes))
            {
                writer.WritePropertyName("involvedKpiTypes"u8);
                writer.WriteStartArray();
                foreach (var item in InvolvedKpiTypes)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(InvolvedRelationships))
            {
                writer.WritePropertyName("involvedRelationships"u8);
                writer.WriteStartArray();
                foreach (var item in InvolvedRelationships)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(NegativeOutcomeExpression))
            {
                writer.WritePropertyName("negativeOutcomeExpression"u8);
                writer.WriteStringValue(NegativeOutcomeExpression);
            }
            if (Optional.IsDefined(PositiveOutcomeExpression))
            {
                writer.WritePropertyName("positiveOutcomeExpression"u8);
                writer.WriteStringValue(PositiveOutcomeExpression);
            }
            if (Optional.IsDefined(PrimaryProfileType))
            {
                writer.WritePropertyName("primaryProfileType"u8);
                writer.WriteStringValue(PrimaryProfileType);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(PredictionName))
            {
                writer.WritePropertyName("predictionName"u8);
                writer.WriteStringValue(PredictionName);
            }
            if (Optional.IsDefined(ScopeExpression))
            {
                writer.WritePropertyName("scopeExpression"u8);
                writer.WriteStringValue(ScopeExpression);
            }
            if (options.Format != "W" && Optional.IsDefined(TenantId))
            {
                writer.WritePropertyName("tenantId"u8);
                writer.WriteStringValue(TenantId.Value);
            }
            if (Optional.IsDefined(AutoAnalyze))
            {
                writer.WritePropertyName("autoAnalyze"u8);
                writer.WriteBooleanValue(AutoAnalyze.Value);
            }
            if (Optional.IsDefined(Mappings))
            {
                writer.WritePropertyName("mappings"u8);
                writer.WriteObjectValue(Mappings, options);
            }
            if (Optional.IsDefined(ScoreLabel))
            {
                writer.WritePropertyName("scoreLabel"u8);
                writer.WriteStringValue(ScoreLabel);
            }
            if (Optional.IsCollectionDefined(Grades))
            {
                writer.WritePropertyName("grades"u8);
                writer.WriteStartArray();
                foreach (var item in Grades)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(SystemGeneratedEntities))
            {
                writer.WritePropertyName("systemGeneratedEntities"u8);
                writer.WriteObjectValue(SystemGeneratedEntities, options);
            }
            writer.WriteEndObject();
        }

        PredictionResourceFormatData IJsonModel<PredictionResourceFormatData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PredictionResourceFormatData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePredictionResourceFormatData(document.RootElement, options);
        }

        internal static PredictionResourceFormatData DeserializePredictionResourceFormatData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            IDictionary<string, string> description = default;
            IDictionary<string, string> displayName = default;
            IList<string> involvedInteractionTypes = default;
            IList<string> involvedKpiTypes = default;
            IList<string> involvedRelationships = default;
            string negativeOutcomeExpression = default;
            string positiveOutcomeExpression = default;
            string primaryProfileType = default;
            ProvisioningState? provisioningState = default;
            string predictionName = default;
            string scopeExpression = default;
            Guid? tenantId = default;
            bool? autoAnalyze = default;
            PredictionMappings mappings = default;
            string scoreLabel = default;
            IList<PredictionGradesItem> grades = default;
            PredictionSystemGeneratedEntities systemGeneratedEntities = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("description"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            description = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("displayName"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            displayName = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("involvedInteractionTypes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            involvedInteractionTypes = array;
                            continue;
                        }
                        if (property0.NameEquals("involvedKpiTypes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            involvedKpiTypes = array;
                            continue;
                        }
                        if (property0.NameEquals("involvedRelationships"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            involvedRelationships = array;
                            continue;
                        }
                        if (property0.NameEquals("negativeOutcomeExpression"u8))
                        {
                            negativeOutcomeExpression = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("positiveOutcomeExpression"u8))
                        {
                            positiveOutcomeExpression = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("primaryProfileType"u8))
                        {
                            primaryProfileType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new ProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("predictionName"u8))
                        {
                            predictionName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("scopeExpression"u8))
                        {
                            scopeExpression = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("tenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            tenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("autoAnalyze"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoAnalyze = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("mappings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            mappings = PredictionMappings.DeserializePredictionMappings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("scoreLabel"u8))
                        {
                            scoreLabel = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("grades"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PredictionGradesItem> array = new List<PredictionGradesItem>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PredictionGradesItem.DeserializePredictionGradesItem(item, options));
                            }
                            grades = array;
                            continue;
                        }
                        if (property0.NameEquals("systemGeneratedEntities"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            systemGeneratedEntities = PredictionSystemGeneratedEntities.DeserializePredictionSystemGeneratedEntities(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PredictionResourceFormatData(
                id,
                name,
                type,
                systemData,
                description ?? new ChangeTrackingDictionary<string, string>(),
                displayName ?? new ChangeTrackingDictionary<string, string>(),
                involvedInteractionTypes ?? new ChangeTrackingList<string>(),
                involvedKpiTypes ?? new ChangeTrackingList<string>(),
                involvedRelationships ?? new ChangeTrackingList<string>(),
                negativeOutcomeExpression,
                positiveOutcomeExpression,
                primaryProfileType,
                provisioningState,
                predictionName,
                scopeExpression,
                tenantId,
                autoAnalyze,
                mappings,
                scoreLabel,
                grades ?? new ChangeTrackingList<PredictionGradesItem>(),
                systemGeneratedEntities,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PredictionResourceFormatData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PredictionResourceFormatData)} does not support writing '{options.Format}' format.");
            }
        }

        PredictionResourceFormatData IPersistableModel<PredictionResourceFormatData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionResourceFormatData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePredictionResourceFormatData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PredictionResourceFormatData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PredictionResourceFormatData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
