// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> Metadata for a Link's property mapping. </summary>
    public partial class TypePropertiesMapping
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TypePropertiesMapping"/>. </summary>
        /// <param name="sourcePropertyName"> Property name on the source Entity Type. </param>
        /// <param name="targetPropertyName"> Property name on the target Entity Type. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourcePropertyName"/> or <paramref name="targetPropertyName"/> is null. </exception>
        public TypePropertiesMapping(string sourcePropertyName, string targetPropertyName)
        {
            Argument.AssertNotNull(sourcePropertyName, nameof(sourcePropertyName));
            Argument.AssertNotNull(targetPropertyName, nameof(targetPropertyName));

            SourcePropertyName = sourcePropertyName;
            TargetPropertyName = targetPropertyName;
        }

        /// <summary> Initializes a new instance of <see cref="TypePropertiesMapping"/>. </summary>
        /// <param name="sourcePropertyName"> Property name on the source Entity Type. </param>
        /// <param name="targetPropertyName"> Property name on the target Entity Type. </param>
        /// <param name="linkType"> Link type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TypePropertiesMapping(string sourcePropertyName, string targetPropertyName, LinkType? linkType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourcePropertyName = sourcePropertyName;
            TargetPropertyName = targetPropertyName;
            LinkType = linkType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TypePropertiesMapping"/> for deserialization. </summary>
        internal TypePropertiesMapping()
        {
        }

        /// <summary> Property name on the source Entity Type. </summary>
        public string SourcePropertyName { get; set; }
        /// <summary> Property name on the target Entity Type. </summary>
        public string TargetPropertyName { get; set; }
        /// <summary> Link type. </summary>
        public LinkType? LinkType { get; set; }
    }
}
