// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> Property/Properties which represent a unique ID. </summary>
    public partial class StrongId
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StrongId"/>. </summary>
        /// <param name="keyPropertyNames"> The properties which make up the unique ID. </param>
        /// <param name="strongIdName"> The Name identifying the strong ID. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="keyPropertyNames"/> or <paramref name="strongIdName"/> is null. </exception>
        public StrongId(IEnumerable<string> keyPropertyNames, string strongIdName)
        {
            Argument.AssertNotNull(keyPropertyNames, nameof(keyPropertyNames));
            Argument.AssertNotNull(strongIdName, nameof(strongIdName));

            KeyPropertyNames = keyPropertyNames.ToList();
            StrongIdName = strongIdName;
            DisplayName = new ChangeTrackingDictionary<string, string>();
            Description = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="StrongId"/>. </summary>
        /// <param name="keyPropertyNames"> The properties which make up the unique ID. </param>
        /// <param name="strongIdName"> The Name identifying the strong ID. </param>
        /// <param name="displayName"> Localized display name. </param>
        /// <param name="description"> Localized descriptions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StrongId(IList<string> keyPropertyNames, string strongIdName, IDictionary<string, string> displayName, IDictionary<string, string> description, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyPropertyNames = keyPropertyNames;
            StrongIdName = strongIdName;
            DisplayName = displayName;
            Description = description;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StrongId"/> for deserialization. </summary>
        internal StrongId()
        {
        }

        /// <summary> The properties which make up the unique ID. </summary>
        public IList<string> KeyPropertyNames { get; }
        /// <summary> The Name identifying the strong ID. </summary>
        public string StrongIdName { get; set; }
        /// <summary> Localized display name. </summary>
        public IDictionary<string, string> DisplayName { get; }
        /// <summary> Localized descriptions. </summary>
        public IDictionary<string, string> Description { get; }
    }
}
