// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class RoleTypeExtensions
    {
        public static string ToSerialString(this RoleType value) => value switch
        {
            RoleType.Admin => "Admin",
            RoleType.Reader => "Reader",
            RoleType.ManageAdmin => "ManageAdmin",
            RoleType.ManageReader => "ManageReader",
            RoleType.DataAdmin => "DataAdmin",
            RoleType.DataReader => "DataReader",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RoleType value.")
        };

        public static RoleType ToRoleType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Admin")) return RoleType.Admin;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Reader")) return RoleType.Reader;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ManageAdmin")) return RoleType.ManageAdmin;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ManageReader")) return RoleType.ManageReader;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DataAdmin")) return RoleType.DataAdmin;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DataReader")) return RoleType.DataReader;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RoleType value.");
        }
    }
}
