// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> The resource set description. </summary>
    public partial class ResourceSetDescription
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceSetDescription"/>. </summary>
        public ResourceSetDescription()
        {
            Elements = new ChangeTrackingList<string>();
            Exceptions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceSetDescription"/>. </summary>
        /// <param name="elements"> The elements included in the set. </param>
        /// <param name="exceptions"> The elements that are not included in the set, in case elements contains '*' indicating 'all'. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceSetDescription(IList<string> elements, IList<string> exceptions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Elements = elements;
            Exceptions = exceptions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The elements included in the set. </summary>
        public IList<string> Elements { get; }
        /// <summary> The elements that are not included in the set, in case elements contains '*' indicating 'all'. </summary>
        public IList<string> Exceptions { get; }
    }
}
