// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> Maps fields in Profile to their corresponding StrongIds in Related Profile. </summary>
    public partial class RelationshipTypeMapping
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RelationshipTypeMapping"/>. </summary>
        /// <param name="fieldMappings"> Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="fieldMappings"/> is null. </exception>
        public RelationshipTypeMapping(IEnumerable<RelationshipTypeFieldMapping> fieldMappings)
        {
            Argument.AssertNotNull(fieldMappings, nameof(fieldMappings));

            FieldMappings = fieldMappings.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="RelationshipTypeMapping"/>. </summary>
        /// <param name="fieldMappings"> Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RelationshipTypeMapping(IList<RelationshipTypeFieldMapping> fieldMappings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FieldMappings = fieldMappings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RelationshipTypeMapping"/> for deserialization. </summary>
        internal RelationshipTypeMapping()
        {
        }

        /// <summary> Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are composite key as well. </summary>
        public IList<RelationshipTypeFieldMapping> FieldMappings { get; }
    }
}
