// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    public partial class RelationshipTypeFieldMapping : IUtf8JsonSerializable, IJsonModel<RelationshipTypeFieldMapping>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RelationshipTypeFieldMapping>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RelationshipTypeFieldMapping>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RelationshipTypeFieldMapping>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RelationshipTypeFieldMapping)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("profileFieldName"u8);
            writer.WriteStringValue(ProfileFieldName);
            writer.WritePropertyName("relatedProfileKeyProperty"u8);
            writer.WriteStringValue(RelatedProfileKeyProperty);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RelationshipTypeFieldMapping IJsonModel<RelationshipTypeFieldMapping>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RelationshipTypeFieldMapping>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RelationshipTypeFieldMapping)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRelationshipTypeFieldMapping(document.RootElement, options);
        }

        internal static RelationshipTypeFieldMapping DeserializeRelationshipTypeFieldMapping(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string profileFieldName = default;
            string relatedProfileKeyProperty = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("profileFieldName"u8))
                {
                    profileFieldName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("relatedProfileKeyProperty"u8))
                {
                    relatedProfileKeyProperty = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RelationshipTypeFieldMapping(profileFieldName, relatedProfileKeyProperty, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RelationshipTypeFieldMapping>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RelationshipTypeFieldMapping>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RelationshipTypeFieldMapping)} does not support writing '{options.Format}' format.");
            }
        }

        RelationshipTypeFieldMapping IPersistableModel<RelationshipTypeFieldMapping>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RelationshipTypeFieldMapping>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRelationshipTypeFieldMapping(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RelationshipTypeFieldMapping)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RelationshipTypeFieldMapping>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
