// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> Property definition. </summary>
    public partial class PropertyDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PropertyDefinition"/>. </summary>
        /// <param name="fieldName"> Name of the property. </param>
        /// <param name="fieldType"> Type of the property. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="fieldName"/> or <paramref name="fieldType"/> is null. </exception>
        public PropertyDefinition(string fieldName, string fieldType)
        {
            Argument.AssertNotNull(fieldName, nameof(fieldName));
            Argument.AssertNotNull(fieldType, nameof(fieldType));

            EnumValidValues = new ChangeTrackingList<ProfileEnumValidValuesFormat>();
            FieldName = fieldName;
            FieldType = fieldType;
            DataSourcePrecedenceRules = new ChangeTrackingList<DataSourcePrecedence>();
        }

        /// <summary> Initializes a new instance of <see cref="PropertyDefinition"/>. </summary>
        /// <param name="arrayValueSeparator"> Array value separator for properties with isArray set. </param>
        /// <param name="enumValidValues"> Describes valid values for an enum property. </param>
        /// <param name="fieldName"> Name of the property. </param>
        /// <param name="fieldType"> Type of the property. </param>
        /// <param name="isArray"> Indicates if the property is actually an array of the fieldType above on the data api. </param>
        /// <param name="isEnum"> Indicates if the property is an enum. </param>
        /// <param name="isFlagEnum"> Indicates if the property is an flag enum. </param>
        /// <param name="isImage"> Whether the property is an Image. </param>
        /// <param name="isLocalizedString"> Whether the property is a localized string. </param>
        /// <param name="isName"> Whether the property is a name or a part of name. </param>
        /// <param name="isRequired"> Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field. </param>
        /// <param name="propertyId"> The ID associated with the property. </param>
        /// <param name="schemaItemPropLink"> URL encoded schema.org item prop link for the property. </param>
        /// <param name="maxLength"> Max length of string. Used only if type is string. </param>
        /// <param name="isAvailableInGraph"> Whether property is available in graph or not. </param>
        /// <param name="dataSourcePrecedenceRules"> This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PropertyDefinition(string arrayValueSeparator, IList<ProfileEnumValidValuesFormat> enumValidValues, string fieldName, string fieldType, bool? isArray, bool? isEnum, bool? isFlagEnum, bool? isImage, bool? isLocalizedString, bool? isName, bool? isRequired, string propertyId, string schemaItemPropLink, int? maxLength, bool? isAvailableInGraph, IReadOnlyList<DataSourcePrecedence> dataSourcePrecedenceRules, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ArrayValueSeparator = arrayValueSeparator;
            EnumValidValues = enumValidValues;
            FieldName = fieldName;
            FieldType = fieldType;
            IsArray = isArray;
            IsEnum = isEnum;
            IsFlagEnum = isFlagEnum;
            IsImage = isImage;
            IsLocalizedString = isLocalizedString;
            IsName = isName;
            IsRequired = isRequired;
            PropertyId = propertyId;
            SchemaItemPropLink = schemaItemPropLink;
            MaxLength = maxLength;
            IsAvailableInGraph = isAvailableInGraph;
            DataSourcePrecedenceRules = dataSourcePrecedenceRules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PropertyDefinition"/> for deserialization. </summary>
        internal PropertyDefinition()
        {
        }

        /// <summary> Array value separator for properties with isArray set. </summary>
        public string ArrayValueSeparator { get; set; }
        /// <summary> Describes valid values for an enum property. </summary>
        public IList<ProfileEnumValidValuesFormat> EnumValidValues { get; }
        /// <summary> Name of the property. </summary>
        public string FieldName { get; set; }
        /// <summary> Type of the property. </summary>
        public string FieldType { get; set; }
        /// <summary> Indicates if the property is actually an array of the fieldType above on the data api. </summary>
        public bool? IsArray { get; set; }
        /// <summary> Indicates if the property is an enum. </summary>
        public bool? IsEnum { get; set; }
        /// <summary> Indicates if the property is an flag enum. </summary>
        public bool? IsFlagEnum { get; set; }
        /// <summary> Whether the property is an Image. </summary>
        public bool? IsImage { get; set; }
        /// <summary> Whether the property is a localized string. </summary>
        public bool? IsLocalizedString { get; set; }
        /// <summary> Whether the property is a name or a part of name. </summary>
        public bool? IsName { get; set; }
        /// <summary> Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field. </summary>
        public bool? IsRequired { get; set; }
        /// <summary> The ID associated with the property. </summary>
        public string PropertyId { get; set; }
        /// <summary> URL encoded schema.org item prop link for the property. </summary>
        public string SchemaItemPropLink { get; set; }
        /// <summary> Max length of string. Used only if type is string. </summary>
        public int? MaxLength { get; set; }
        /// <summary> Whether property is available in graph or not. </summary>
        public bool? IsAvailableInGraph { get; set; }
        /// <summary> This is specific to interactions modeled as activities. Data sources are used to determine where data is stored and also in precedence rules. </summary>
        public IReadOnlyList<DataSourcePrecedence> DataSourcePrecedenceRules { get; }
    }
}
