// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    public partial class PropertyDefinition : IUtf8JsonSerializable, IJsonModel<PropertyDefinition>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PropertyDefinition>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PropertyDefinition>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PropertyDefinition>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PropertyDefinition)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ArrayValueSeparator))
            {
                writer.WritePropertyName("arrayValueSeparator"u8);
                writer.WriteStringValue(ArrayValueSeparator);
            }
            if (Optional.IsCollectionDefined(EnumValidValues))
            {
                writer.WritePropertyName("enumValidValues"u8);
                writer.WriteStartArray();
                foreach (var item in EnumValidValues)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("fieldName"u8);
            writer.WriteStringValue(FieldName);
            writer.WritePropertyName("fieldType"u8);
            writer.WriteStringValue(FieldType);
            if (Optional.IsDefined(IsArray))
            {
                writer.WritePropertyName("isArray"u8);
                writer.WriteBooleanValue(IsArray.Value);
            }
            if (Optional.IsDefined(IsEnum))
            {
                writer.WritePropertyName("isEnum"u8);
                writer.WriteBooleanValue(IsEnum.Value);
            }
            if (Optional.IsDefined(IsFlagEnum))
            {
                writer.WritePropertyName("isFlagEnum"u8);
                writer.WriteBooleanValue(IsFlagEnum.Value);
            }
            if (Optional.IsDefined(IsImage))
            {
                writer.WritePropertyName("isImage"u8);
                writer.WriteBooleanValue(IsImage.Value);
            }
            if (Optional.IsDefined(IsLocalizedString))
            {
                writer.WritePropertyName("isLocalizedString"u8);
                writer.WriteBooleanValue(IsLocalizedString.Value);
            }
            if (Optional.IsDefined(IsName))
            {
                writer.WritePropertyName("isName"u8);
                writer.WriteBooleanValue(IsName.Value);
            }
            if (Optional.IsDefined(IsRequired))
            {
                writer.WritePropertyName("isRequired"u8);
                writer.WriteBooleanValue(IsRequired.Value);
            }
            if (Optional.IsDefined(PropertyId))
            {
                writer.WritePropertyName("propertyId"u8);
                writer.WriteStringValue(PropertyId);
            }
            if (Optional.IsDefined(SchemaItemPropLink))
            {
                writer.WritePropertyName("schemaItemPropLink"u8);
                writer.WriteStringValue(SchemaItemPropLink);
            }
            if (Optional.IsDefined(MaxLength))
            {
                writer.WritePropertyName("maxLength"u8);
                writer.WriteNumberValue(MaxLength.Value);
            }
            if (Optional.IsDefined(IsAvailableInGraph))
            {
                writer.WritePropertyName("isAvailableInGraph"u8);
                writer.WriteBooleanValue(IsAvailableInGraph.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(DataSourcePrecedenceRules))
            {
                writer.WritePropertyName("dataSourcePrecedenceRules"u8);
                writer.WriteStartArray();
                foreach (var item in DataSourcePrecedenceRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PropertyDefinition IJsonModel<PropertyDefinition>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PropertyDefinition>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PropertyDefinition)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePropertyDefinition(document.RootElement, options);
        }

        internal static PropertyDefinition DeserializePropertyDefinition(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string arrayValueSeparator = default;
            IList<ProfileEnumValidValuesFormat> enumValidValues = default;
            string fieldName = default;
            string fieldType = default;
            bool? isArray = default;
            bool? isEnum = default;
            bool? isFlagEnum = default;
            bool? isImage = default;
            bool? isLocalizedString = default;
            bool? isName = default;
            bool? isRequired = default;
            string propertyId = default;
            string schemaItemPropLink = default;
            int? maxLength = default;
            bool? isAvailableInGraph = default;
            IReadOnlyList<DataSourcePrecedence> dataSourcePrecedenceRules = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("arrayValueSeparator"u8))
                {
                    arrayValueSeparator = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("enumValidValues"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ProfileEnumValidValuesFormat> array = new List<ProfileEnumValidValuesFormat>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ProfileEnumValidValuesFormat.DeserializeProfileEnumValidValuesFormat(item, options));
                    }
                    enumValidValues = array;
                    continue;
                }
                if (property.NameEquals("fieldName"u8))
                {
                    fieldName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fieldType"u8))
                {
                    fieldType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isArray"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isArray = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isEnum"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isEnum = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isFlagEnum"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isFlagEnum = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isImage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isImage = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isLocalizedString"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isLocalizedString = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isName = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isRequired"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isRequired = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("propertyId"u8))
                {
                    propertyId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("schemaItemPropLink"u8))
                {
                    schemaItemPropLink = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("maxLength"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxLength = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("isAvailableInGraph"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isAvailableInGraph = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("dataSourcePrecedenceRules"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DataSourcePrecedence> array = new List<DataSourcePrecedence>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DataSourcePrecedence.DeserializeDataSourcePrecedence(item, options));
                    }
                    dataSourcePrecedenceRules = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PropertyDefinition(
                arrayValueSeparator,
                enumValidValues ?? new ChangeTrackingList<ProfileEnumValidValuesFormat>(),
                fieldName,
                fieldType,
                isArray,
                isEnum,
                isFlagEnum,
                isImage,
                isLocalizedString,
                isName,
                isRequired,
                propertyId,
                schemaItemPropLink,
                maxLength,
                isAvailableInGraph,
                dataSourcePrecedenceRules ?? new ChangeTrackingList<DataSourcePrecedence>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PropertyDefinition>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PropertyDefinition>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PropertyDefinition)} does not support writing '{options.Format}' format.");
            }
        }

        PropertyDefinition IPersistableModel<PropertyDefinition>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PropertyDefinition>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePropertyDefinition(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PropertyDefinition)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PropertyDefinition>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
