// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> The training results of the prediction. </summary>
    public partial class PredictionTrainingResults
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PredictionTrainingResults"/>. </summary>
        internal PredictionTrainingResults()
        {
            CanonicalProfiles = new ChangeTrackingList<CanonicalProfileDefinition>();
        }

        /// <summary> Initializes a new instance of <see cref="PredictionTrainingResults"/>. </summary>
        /// <param name="tenantId"> The hub name. </param>
        /// <param name="scoreName"> Score name. </param>
        /// <param name="predictionDistribution"> Prediction distribution. </param>
        /// <param name="canonicalProfiles"> Canonical profiles. </param>
        /// <param name="primaryProfileInstanceCount"> Instance count of the primary profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PredictionTrainingResults(Guid? tenantId, string scoreName, PredictionDistributionDefinition predictionDistribution, IReadOnlyList<CanonicalProfileDefinition> canonicalProfiles, long? primaryProfileInstanceCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TenantId = tenantId;
            ScoreName = scoreName;
            PredictionDistribution = predictionDistribution;
            CanonicalProfiles = canonicalProfiles;
            PrimaryProfileInstanceCount = primaryProfileInstanceCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The hub name. </summary>
        public Guid? TenantId { get; }
        /// <summary> Score name. </summary>
        public string ScoreName { get; }
        /// <summary> Prediction distribution. </summary>
        public PredictionDistributionDefinition PredictionDistribution { get; }
        /// <summary> Canonical profiles. </summary>
        public IReadOnlyList<CanonicalProfileDefinition> CanonicalProfiles { get; }
        /// <summary> Instance count of the primary profile. </summary>
        public long? PrimaryProfileInstanceCount { get; }
    }
}
