// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    public partial class PredictionSystemGeneratedEntities : IUtf8JsonSerializable, IJsonModel<PredictionSystemGeneratedEntities>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PredictionSystemGeneratedEntities>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PredictionSystemGeneratedEntities>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionSystemGeneratedEntities>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PredictionSystemGeneratedEntities)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(GeneratedInteractionTypes))
            {
                writer.WritePropertyName("generatedInteractionTypes"u8);
                writer.WriteStartArray();
                foreach (var item in GeneratedInteractionTypes)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(GeneratedLinks))
            {
                writer.WritePropertyName("generatedLinks"u8);
                writer.WriteStartArray();
                foreach (var item in GeneratedLinks)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(GeneratedKpis))
            {
                writer.WritePropertyName("generatedKpis"u8);
                writer.WriteStartObject();
                foreach (var item in GeneratedKpis)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PredictionSystemGeneratedEntities IJsonModel<PredictionSystemGeneratedEntities>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionSystemGeneratedEntities>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PredictionSystemGeneratedEntities)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePredictionSystemGeneratedEntities(document.RootElement, options);
        }

        internal static PredictionSystemGeneratedEntities DeserializePredictionSystemGeneratedEntities(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<string> generatedInteractionTypes = default;
            IReadOnlyList<string> generatedLinks = default;
            IReadOnlyDictionary<string, string> generatedKpis = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("generatedInteractionTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    generatedInteractionTypes = array;
                    continue;
                }
                if (property.NameEquals("generatedLinks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    generatedLinks = array;
                    continue;
                }
                if (property.NameEquals("generatedKpis"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    generatedKpis = dictionary;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PredictionSystemGeneratedEntities(generatedInteractionTypes ?? new ChangeTrackingList<string>(), generatedLinks ?? new ChangeTrackingList<string>(), generatedKpis ?? new ChangeTrackingDictionary<string, string>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PredictionSystemGeneratedEntities>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionSystemGeneratedEntities>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PredictionSystemGeneratedEntities)} does not support writing '{options.Format}' format.");
            }
        }

        PredictionSystemGeneratedEntities IPersistableModel<PredictionSystemGeneratedEntities>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionSystemGeneratedEntities>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePredictionSystemGeneratedEntities(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PredictionSystemGeneratedEntities)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PredictionSystemGeneratedEntities>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
