// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> The definition of a prediction distribution. </summary>
    public partial class PredictionDistributionDefinitionDistributionsItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PredictionDistributionDefinitionDistributionsItem"/>. </summary>
        internal PredictionDistributionDefinitionDistributionsItem()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PredictionDistributionDefinitionDistributionsItem"/>. </summary>
        /// <param name="scoreThreshold"> Score threshold. </param>
        /// <param name="positives"> Number of positives. </param>
        /// <param name="negatives"> Number of negatives. </param>
        /// <param name="positivesAboveThreshold"> Number of positives above threshold. </param>
        /// <param name="negativesAboveThreshold"> Number of negatives above threshold. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PredictionDistributionDefinitionDistributionsItem(int? scoreThreshold, long? positives, long? negatives, long? positivesAboveThreshold, long? negativesAboveThreshold, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ScoreThreshold = scoreThreshold;
            Positives = positives;
            Negatives = negatives;
            PositivesAboveThreshold = positivesAboveThreshold;
            NegativesAboveThreshold = negativesAboveThreshold;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Score threshold. </summary>
        public int? ScoreThreshold { get; }
        /// <summary> Number of positives. </summary>
        public long? Positives { get; }
        /// <summary> Number of negatives. </summary>
        public long? Negatives { get; }
        /// <summary> Number of positives above threshold. </summary>
        public long? PositivesAboveThreshold { get; }
        /// <summary> Number of negatives above threshold. </summary>
        public long? NegativesAboveThreshold { get; }
    }
}
