// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    public partial class PredictionDistributionDefinitionDistributionsItem : IUtf8JsonSerializable, IJsonModel<PredictionDistributionDefinitionDistributionsItem>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PredictionDistributionDefinitionDistributionsItem>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PredictionDistributionDefinitionDistributionsItem>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionDistributionDefinitionDistributionsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PredictionDistributionDefinitionDistributionsItem)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ScoreThreshold))
            {
                writer.WritePropertyName("scoreThreshold"u8);
                writer.WriteNumberValue(ScoreThreshold.Value);
            }
            if (Optional.IsDefined(Positives))
            {
                writer.WritePropertyName("positives"u8);
                writer.WriteNumberValue(Positives.Value);
            }
            if (Optional.IsDefined(Negatives))
            {
                writer.WritePropertyName("negatives"u8);
                writer.WriteNumberValue(Negatives.Value);
            }
            if (Optional.IsDefined(PositivesAboveThreshold))
            {
                writer.WritePropertyName("positivesAboveThreshold"u8);
                writer.WriteNumberValue(PositivesAboveThreshold.Value);
            }
            if (Optional.IsDefined(NegativesAboveThreshold))
            {
                writer.WritePropertyName("negativesAboveThreshold"u8);
                writer.WriteNumberValue(NegativesAboveThreshold.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PredictionDistributionDefinitionDistributionsItem IJsonModel<PredictionDistributionDefinitionDistributionsItem>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionDistributionDefinitionDistributionsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PredictionDistributionDefinitionDistributionsItem)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePredictionDistributionDefinitionDistributionsItem(document.RootElement, options);
        }

        internal static PredictionDistributionDefinitionDistributionsItem DeserializePredictionDistributionDefinitionDistributionsItem(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? scoreThreshold = default;
            long? positives = default;
            long? negatives = default;
            long? positivesAboveThreshold = default;
            long? negativesAboveThreshold = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("scoreThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scoreThreshold = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("positives"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    positives = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("negatives"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    negatives = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("positivesAboveThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    positivesAboveThreshold = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("negativesAboveThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    negativesAboveThreshold = property.Value.GetInt64();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PredictionDistributionDefinitionDistributionsItem(
                scoreThreshold,
                positives,
                negatives,
                positivesAboveThreshold,
                negativesAboveThreshold,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PredictionDistributionDefinitionDistributionsItem>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionDistributionDefinitionDistributionsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PredictionDistributionDefinitionDistributionsItem)} does not support writing '{options.Format}' format.");
            }
        }

        PredictionDistributionDefinitionDistributionsItem IPersistableModel<PredictionDistributionDefinitionDistributionsItem>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PredictionDistributionDefinitionDistributionsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePredictionDistributionDefinitionDistributionsItem(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PredictionDistributionDefinitionDistributionsItem)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PredictionDistributionDefinitionDistributionsItem>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
