// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> The definition of the prediction distribution. </summary>
    public partial class PredictionDistributionDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PredictionDistributionDefinition"/>. </summary>
        internal PredictionDistributionDefinition()
        {
            Distributions = new ChangeTrackingList<PredictionDistributionDefinitionDistributionsItem>();
        }

        /// <summary> Initializes a new instance of <see cref="PredictionDistributionDefinition"/>. </summary>
        /// <param name="totalPositives"> Total positive in the distribution. </param>
        /// <param name="totalNegatives"> Total negatives in the distribution. </param>
        /// <param name="distributions"> Distributions of the prediction. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PredictionDistributionDefinition(long? totalPositives, long? totalNegatives, IReadOnlyList<PredictionDistributionDefinitionDistributionsItem> distributions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TotalPositives = totalPositives;
            TotalNegatives = totalNegatives;
            Distributions = distributions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Total positive in the distribution. </summary>
        public long? TotalPositives { get; }
        /// <summary> Total negatives in the distribution. </summary>
        public long? TotalNegatives { get; }
        /// <summary> Distributions of the prediction. </summary>
        public IReadOnlyList<PredictionDistributionDefinitionDistributionsItem> Distributions { get; }
    }
}
