// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> The participant property reference. </summary>
    public partial class ParticipantPropertyReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ParticipantPropertyReference"/>. </summary>
        /// <param name="sourcePropertyName"> The source property that maps to the target property. </param>
        /// <param name="targetPropertyName"> The target property that maps to the source property. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourcePropertyName"/> or <paramref name="targetPropertyName"/> is null. </exception>
        public ParticipantPropertyReference(string sourcePropertyName, string targetPropertyName)
        {
            Argument.AssertNotNull(sourcePropertyName, nameof(sourcePropertyName));
            Argument.AssertNotNull(targetPropertyName, nameof(targetPropertyName));

            SourcePropertyName = sourcePropertyName;
            TargetPropertyName = targetPropertyName;
        }

        /// <summary> Initializes a new instance of <see cref="ParticipantPropertyReference"/>. </summary>
        /// <param name="sourcePropertyName"> The source property that maps to the target property. </param>
        /// <param name="targetPropertyName"> The target property that maps to the source property. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ParticipantPropertyReference(string sourcePropertyName, string targetPropertyName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourcePropertyName = sourcePropertyName;
            TargetPropertyName = targetPropertyName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ParticipantPropertyReference"/> for deserialization. </summary>
        internal ParticipantPropertyReference()
        {
        }

        /// <summary> The source property that maps to the target property. </summary>
        public string SourcePropertyName { get; set; }
        /// <summary> The target property that maps to the source property. </summary>
        public string TargetPropertyName { get; set; }
    }
}
