// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    public partial class ParticipantPropertyReference : IUtf8JsonSerializable, IJsonModel<ParticipantPropertyReference>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ParticipantPropertyReference>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ParticipantPropertyReference>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ParticipantPropertyReference>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ParticipantPropertyReference)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("sourcePropertyName"u8);
            writer.WriteStringValue(SourcePropertyName);
            writer.WritePropertyName("targetPropertyName"u8);
            writer.WriteStringValue(TargetPropertyName);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ParticipantPropertyReference IJsonModel<ParticipantPropertyReference>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ParticipantPropertyReference>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ParticipantPropertyReference)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeParticipantPropertyReference(document.RootElement, options);
        }

        internal static ParticipantPropertyReference DeserializeParticipantPropertyReference(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string sourcePropertyName = default;
            string targetPropertyName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sourcePropertyName"u8))
                {
                    sourcePropertyName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetPropertyName"u8))
                {
                    targetPropertyName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ParticipantPropertyReference(sourcePropertyName, targetPropertyName, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ParticipantPropertyReference>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ParticipantPropertyReference>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ParticipantPropertyReference)} does not support writing '{options.Format}' format.");
            }
        }

        ParticipantPropertyReference IPersistableModel<ParticipantPropertyReference>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ParticipantPropertyReference>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeParticipantPropertyReference(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ParticipantPropertyReference)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ParticipantPropertyReference>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
