// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    public partial class ParticipantProfilePropertyReference : IUtf8JsonSerializable, IJsonModel<ParticipantProfilePropertyReference>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ParticipantProfilePropertyReference>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ParticipantProfilePropertyReference>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ParticipantProfilePropertyReference>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ParticipantProfilePropertyReference)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("interactionPropertyName"u8);
            writer.WriteStringValue(InteractionPropertyName);
            writer.WritePropertyName("profilePropertyName"u8);
            writer.WriteStringValue(ProfilePropertyName);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ParticipantProfilePropertyReference IJsonModel<ParticipantProfilePropertyReference>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ParticipantProfilePropertyReference>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ParticipantProfilePropertyReference)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeParticipantProfilePropertyReference(document.RootElement, options);
        }

        internal static ParticipantProfilePropertyReference DeserializeParticipantProfilePropertyReference(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string interactionPropertyName = default;
            string profilePropertyName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("interactionPropertyName"u8))
                {
                    interactionPropertyName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("profilePropertyName"u8))
                {
                    profilePropertyName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ParticipantProfilePropertyReference(interactionPropertyName, profilePropertyName, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ParticipantProfilePropertyReference>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ParticipantProfilePropertyReference>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ParticipantProfilePropertyReference)} does not support writing '{options.Format}' format.");
            }
        }

        ParticipantProfilePropertyReference IPersistableModel<ParticipantProfilePropertyReference>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ParticipantProfilePropertyReference>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeParticipantProfilePropertyReference(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ParticipantProfilePropertyReference)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ParticipantProfilePropertyReference>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
