// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class LinkTypeExtensions
    {
        public static string ToSerialString(this LinkType value) => value switch
        {
            LinkType.UpdateAlways => "UpdateAlways",
            LinkType.CopyIfNull => "CopyIfNull",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LinkType value.")
        };

        public static LinkType ToLinkType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "UpdateAlways")) return LinkType.UpdateAlways;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CopyIfNull")) return LinkType.CopyIfNull;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LinkType value.");
        }
    }
}
