// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> Defines the KPI Threshold limits. </summary>
    public partial class KpiThresholds
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KpiThresholds"/>. </summary>
        /// <param name="lowerLimit"> The lower threshold limit. </param>
        /// <param name="upperLimit"> The upper threshold limit. </param>
        /// <param name="increasingKpi"> Whether or not the KPI is an increasing KPI. </param>
        public KpiThresholds(decimal lowerLimit, decimal upperLimit, bool increasingKpi)
        {
            LowerLimit = lowerLimit;
            UpperLimit = upperLimit;
            IncreasingKpi = increasingKpi;
        }

        /// <summary> Initializes a new instance of <see cref="KpiThresholds"/>. </summary>
        /// <param name="lowerLimit"> The lower threshold limit. </param>
        /// <param name="upperLimit"> The upper threshold limit. </param>
        /// <param name="increasingKpi"> Whether or not the KPI is an increasing KPI. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KpiThresholds(decimal lowerLimit, decimal upperLimit, bool increasingKpi, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LowerLimit = lowerLimit;
            UpperLimit = upperLimit;
            IncreasingKpi = increasingKpi;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="KpiThresholds"/> for deserialization. </summary>
        internal KpiThresholds()
        {
        }

        /// <summary> The lower threshold limit. </summary>
        public decimal LowerLimit { get; set; }
        /// <summary> The upper threshold limit. </summary>
        public decimal UpperLimit { get; set; }
        /// <summary> Whether or not the KPI is an increasing KPI. </summary>
        public bool IncreasingKpi { get; set; }
    }
}
