// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> The KPI participant profile metadata. </summary>
    public partial class KpiParticipantProfilesMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KpiParticipantProfilesMetadata"/>. </summary>
        /// <param name="typeName"> Name of the type. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="typeName"/> is null. </exception>
        internal KpiParticipantProfilesMetadata(string typeName)
        {
            Argument.AssertNotNull(typeName, nameof(typeName));

            TypeName = typeName;
        }

        /// <summary> Initializes a new instance of <see cref="KpiParticipantProfilesMetadata"/>. </summary>
        /// <param name="typeName"> Name of the type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KpiParticipantProfilesMetadata(string typeName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TypeName = typeName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="KpiParticipantProfilesMetadata"/> for deserialization. </summary>
        internal KpiParticipantProfilesMetadata()
        {
        }

        /// <summary> Name of the type. </summary>
        public string TypeName { get; }
    }
}
