// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class KpiFunctionExtensions
    {
        public static string ToSerialString(this KpiFunction value) => value switch
        {
            KpiFunction.None => "None",
            KpiFunction.Sum => "Sum",
            KpiFunction.Avg => "Avg",
            KpiFunction.Min => "Min",
            KpiFunction.Max => "Max",
            KpiFunction.Last => "Last",
            KpiFunction.Count => "Count",
            KpiFunction.CountDistinct => "CountDistinct",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown KpiFunction value.")
        };

        public static KpiFunction ToKpiFunction(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return KpiFunction.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Sum")) return KpiFunction.Sum;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Avg")) return KpiFunction.Avg;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Min")) return KpiFunction.Min;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Max")) return KpiFunction.Max;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Last")) return KpiFunction.Last;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Count")) return KpiFunction.Count;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CountDistinct")) return KpiFunction.CountDistinct;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown KpiFunction value.");
        }
    }
}
