// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> The image definition. </summary>
    public partial class ImageDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ImageDefinition"/>. </summary>
        internal ImageDefinition()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ImageDefinition"/>. </summary>
        /// <param name="imageExists"> Whether image exists already. </param>
        /// <param name="contentUri"> Content URL for the image blob. </param>
        /// <param name="relativePath"> Relative path of the image. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ImageDefinition(bool? imageExists, Uri contentUri, string relativePath, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ImageExists = imageExists;
            ContentUri = contentUri;
            RelativePath = relativePath;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Whether image exists already. </summary>
        public bool? ImageExists { get; }
        /// <summary> Content URL for the image blob. </summary>
        public Uri ContentUri { get; }
        /// <summary> Relative path of the image. </summary>
        public string RelativePath { get; }
    }
}
