// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class FrequencyTypeExtensions
    {
        public static string ToSerialString(this FrequencyType value) => value switch
        {
            FrequencyType.Minute => "Minute",
            FrequencyType.Hour => "Hour",
            FrequencyType.Day => "Day",
            FrequencyType.Week => "Week",
            FrequencyType.Month => "Month",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FrequencyType value.")
        };

        public static FrequencyType ToFrequencyType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Minute")) return FrequencyType.Minute;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Hour")) return FrequencyType.Hour;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Day")) return FrequencyType.Day;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Week")) return FrequencyType.Week;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Month")) return FrequencyType.Month;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FrequencyType value.");
        }
    }
}
