// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> The type mapping format. </summary>
    public readonly partial struct FormatType : IEquatable<FormatType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FormatType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FormatType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TextFormatValue = "TextFormat";

        /// <summary> TextFormat. </summary>
        public static FormatType TextFormat { get; } = new FormatType(TextFormatValue);
        /// <summary> Determines if two <see cref="FormatType"/> values are the same. </summary>
        public static bool operator ==(FormatType left, FormatType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FormatType"/> values are not the same. </summary>
        public static bool operator !=(FormatType left, FormatType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FormatType"/>. </summary>
        public static implicit operator FormatType(string value) => new FormatType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FormatType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FormatType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
