// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class ErrorManagementTypeExtensions
    {
        public static string ToSerialString(this ErrorManagementType value) => value switch
        {
            ErrorManagementType.RejectAndContinue => "RejectAndContinue",
            ErrorManagementType.StopImport => "StopImport",
            ErrorManagementType.RejectUntilLimit => "RejectUntilLimit",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ErrorManagementType value.")
        };

        public static ErrorManagementType ToErrorManagementType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RejectAndContinue")) return ErrorManagementType.RejectAndContinue;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "StopImport")) return ErrorManagementType.StopImport;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RejectUntilLimit")) return ErrorManagementType.RejectUntilLimit;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ErrorManagementType value.");
        }
    }
}
