// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class EntityTypeExtensions
    {
        public static string ToSerialString(this EntityType value) => value switch
        {
            EntityType.None => "None",
            EntityType.Profile => "Profile",
            EntityType.Interaction => "Interaction",
            EntityType.Relationship => "Relationship",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EntityType value.")
        };

        public static EntityType ToEntityType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return EntityType.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Profile")) return EntityType.Profile;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Interaction")) return EntityType.Interaction;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Relationship")) return EntityType.Relationship;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EntityType value.");
        }
    }
}
