// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> The data source precedence is a way to know the precedence of each data source. </summary>
    public partial class DataSourcePrecedence
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataSourcePrecedence"/>. </summary>
        internal DataSourcePrecedence()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataSourcePrecedence"/>. </summary>
        /// <param name="precedence"> the precedence value. </param>
        /// <param name="name"> The data source name. </param>
        /// <param name="dataSourceType"> The data source type. </param>
        /// <param name="status"> The data source status. </param>
        /// <param name="id"> The data source ID. </param>
        /// <param name="dataSourceReferenceId"> The data source reference id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataSourcePrecedence(int? precedence, string name, DataSourceType? dataSourceType, Status? status, int? id, string dataSourceReferenceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Precedence = precedence;
            Name = name;
            DataSourceType = dataSourceType;
            Status = status;
            Id = id;
            DataSourceReferenceId = dataSourceReferenceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> the precedence value. </summary>
        public int? Precedence { get; }
        /// <summary> The data source name. </summary>
        public string Name { get; }
        /// <summary> The data source type. </summary>
        public DataSourceType? DataSourceType { get; }
        /// <summary> The data source status. </summary>
        public Status? Status { get; }
        /// <summary> The data source ID. </summary>
        public int? Id { get; }
        /// <summary> The data source reference id. </summary>
        public string DataSourceReferenceId { get; }
    }
}
