// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class ConnectorStateExtensions
    {
        public static string ToSerialString(this ConnectorState value) => value switch
        {
            ConnectorState.Creating => "Creating",
            ConnectorState.Created => "Created",
            ConnectorState.Ready => "Ready",
            ConnectorState.Expiring => "Expiring",
            ConnectorState.Deleting => "Deleting",
            ConnectorState.Failed => "Failed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ConnectorState value.")
        };

        public static ConnectorState ToConnectorState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Creating")) return ConnectorState.Creating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Created")) return ConnectorState.Created;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Ready")) return ConnectorState.Ready;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Expiring")) return ConnectorState.Expiring;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deleting")) return ConnectorState.Deleting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return ConnectorState.Failed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ConnectorState value.");
        }
    }
}
