// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    /// <summary> Connector mapping property structure. </summary>
    public partial class ConnectorMappingStructure
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectorMappingStructure"/>. </summary>
        /// <param name="propertyName"> The property name of the mapping entity. </param>
        /// <param name="columnName"> The column name of the import file. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="propertyName"/> or <paramref name="columnName"/> is null. </exception>
        public ConnectorMappingStructure(string propertyName, string columnName)
        {
            Argument.AssertNotNull(propertyName, nameof(propertyName));
            Argument.AssertNotNull(columnName, nameof(columnName));

            PropertyName = propertyName;
            ColumnName = columnName;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorMappingStructure"/>. </summary>
        /// <param name="propertyName"> The property name of the mapping entity. </param>
        /// <param name="columnName"> The column name of the import file. </param>
        /// <param name="customFormatSpecifier"> Custom format specifier for input parsing. </param>
        /// <param name="isEncrypted"> Indicates if the column is encrypted. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectorMappingStructure(string propertyName, string columnName, string customFormatSpecifier, bool? isEncrypted, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PropertyName = propertyName;
            ColumnName = columnName;
            CustomFormatSpecifier = customFormatSpecifier;
            IsEncrypted = isEncrypted;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorMappingStructure"/> for deserialization. </summary>
        internal ConnectorMappingStructure()
        {
        }

        /// <summary> The property name of the mapping entity. </summary>
        public string PropertyName { get; set; }
        /// <summary> The column name of the import file. </summary>
        public string ColumnName { get; set; }
        /// <summary> Custom format specifier for input parsing. </summary>
        public string CustomFormatSpecifier { get; set; }
        /// <summary> Indicates if the column is encrypted. </summary>
        public bool? IsEncrypted { get; set; }
    }
}
