// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.CustomerInsights.Models
{
    internal static partial class ConnectorMappingStateExtensions
    {
        public static string ToSerialString(this ConnectorMappingState value) => value switch
        {
            ConnectorMappingState.Creating => "Creating",
            ConnectorMappingState.Created => "Created",
            ConnectorMappingState.Failed => "Failed",
            ConnectorMappingState.Ready => "Ready",
            ConnectorMappingState.Running => "Running",
            ConnectorMappingState.Stopped => "Stopped",
            ConnectorMappingState.Expiring => "Expiring",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ConnectorMappingState value.")
        };

        public static ConnectorMappingState ToConnectorMappingState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Creating")) return ConnectorMappingState.Creating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Created")) return ConnectorMappingState.Created;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return ConnectorMappingState.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Ready")) return ConnectorMappingState.Ready;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Running")) return ConnectorMappingState.Running;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Stopped")) return ConnectorMappingState.Stopped;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Expiring")) return ConnectorMappingState.Expiring;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ConnectorMappingState value.");
        }
    }
}
